"use client";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import classNames from "classnames";
import Loader from "../loader";
import CheckIcon from "../icons/check";
import css from "../input/input.module.css";
function TextArea({ label = "", className, valid, error, patternError, compact, loading, value, onChange, onValueChange, autoSizing, ...props }, ref) {
    const innerRef = React.useRef(null);
    const [touched, setTouched] = React.useState(false);
    const _onChange = (e) => {
        onChange?.(e);
        onValueChange?.(e.target.value);
    };
    const updateTextAreaHeight = React.useCallback(() => {
        const container = innerRef.current;
        if (!autoSizing || !container)
            return;
        const field = container.querySelector("textarea");
        if (field) {
            field.style.height = "inherit";
            const computedStyle = window.getComputedStyle(field);
            const paddingTop = parseInt(computedStyle.getPropertyValue("padding-top") ?? "0");
            const paddingBottom = parseInt(computedStyle.getPropertyValue("padding-bottom") ?? "0");
            const height = paddingTop + field.scrollHeight + paddingBottom;
            field.style.height = `${height}px`;
        }
    }, [autoSizing]);
    const handleInput = (e) => {
        updateTextAreaHeight();
        props.onInput?.(e);
    };
    const handleFocus = (e) => {
        updateTextAreaHeight();
        props.onInput?.(e);
    };
    const handleBlur = (e) => {
        const value = e.target.value;
        if (value.trim().length > 0) {
            setTouched(true);
        }
        props.onBlur?.(e);
    };
    React.useEffect(() => {
        updateTextAreaHeight();
    }, [updateTextAreaHeight]);
    const isValid = valid && !error;
    const classes = classNames(css.textarea, className, {
        [css.touched]: touched,
        [css.compact]: compact,
        [css.autoSizing]: autoSizing,
        [css.valid]: isValid,
        [css.error]: error,
    });
    return (_jsxs("div", { ref: ref, className: classes, children: [_jsxs("label", { className: css.label, children: [(label || isValid) && (_jsxs("span", { className: css.labelText, children: [label, isValid && _jsx(CheckIcon, { className: css.validIndicator })] })), _jsxs("div", { ref: innerRef, className: css.fieldWrapper, children: [_jsx("textarea", { ...props, className: css.field, value: value, onChange: _onChange, onInput: handleInput, onFocus: handleFocus, onBlur: handleBlur, "aria-invalid": isValid !== undefined && !isValid, disabled: loading || props.disabled }), loading && _jsx(Loader, { variant: "overlay", className: css.loader })] })] }), patternError && (_jsx("div", { className: css.patternErrorMessage, children: patternError })), error && (_jsx("div", { className: css.errorMessage, role: "alert", children: error }))] }));
}
export default React.forwardRef(TextArea);
