import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import classNames from "classnames";
import * as TabsPrimitives from "@radix-ui/react-tabs";
import styles from "./tabs.module.css";
export default function Tabs({ tabs = [], value, defaultValue, className, onValueChange, dir, activationMode, orientation, }) {
    const classes = classNames(styles.root, className);
    return (_jsxs(TabsPrimitives.Root, { className: classes, defaultValue: defaultValue, value: value, onValueChange: onValueChange, orientation: orientation, dir: dir, activationMode: activationMode, children: [_jsx(TabsPrimitives.List, { className: styles.tabs, children: tabs.map((tab) => {
                    return (_jsx(TabsPrimitives.Trigger, { className: styles.tab, value: tab.value, children: tab.label }, tab.value));
                }) }), tabs.map((tab) => {
                return (_jsx(TabsPrimitives.Content, { className: styles.content, value: tab.value, children: tab.content }, tab.value));
            })] }));
}
