import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import classNames from "classnames";
import Button from "../button";
import Portal from "../portal";
import CheckCircleIcon from "../icons/check-circle";
import AlertCircleIcon from "../icons/alert-circle";
import AlertTriangleIcon from "../icons/alert-triangle";
import InfoCircleIcon from "../icons/info-circle";
import CloseIcon from "../icons/close";
import css from "./snackbar.module.css";
const icons = {
    success: CheckCircleIcon,
    error: AlertCircleIcon,
    warning: AlertTriangleIcon,
    information: InfoCircleIcon,
};
export default function Snackbar({ container, type = "information", showIcon = true, delay = 4500, message, filler = true, showCloseButton = true, close, closing, style = {}, }) {
    const Icon = icons[type] || icons.information;
    const classes = classNames(css.root, {
        [css[type]]: type,
        [css.filler]: filler,
        [css.closing]: closing,
    });
    const styles = filler
        ? { "--filler-duration": `${delay}ms`, ...style }
        : style;
    return (_jsx(Portal, { container: container, asChild: true, children: _jsxs("div", { className: classes, style: styles, children: [_jsxs("div", { className: css.message, children: [showIcon && _jsx(Icon, { className: css.icon }), _jsx("div", { className: css.text, children: message })] }), showCloseButton && (_jsx(Button, { variant: "transparent", className: css.close, onClick: () => close(), compact: true, children: _jsx(CloseIcon, { className: css.closeIcon }) }))] }) }));
}
