"use client";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import Snackbar from "./snackbar";
const CLOSING_DELAY = 320;
const DEFAULT_DELAY = 4500;
const SnackbarContext = React.createContext({
    show: () => { },
    hide: () => { },
});
export function useSnackbar() {
    const context = React.useContext(SnackbarContext);
    if (!context)
        throw new Error(`useSnackbar must be used within a SnackbarProvider`);
    return context;
}
export default function SnackbarProvider({ children }) {
    const [uniqueId, setUniqueId] = React.useState();
    const [snackbar, setSnackbar] = React.useState();
    const [closing, setClosing] = React.useState(false);
    const [visibilityTimeout, setVisibilityTimeout] = React.useState();
    const [delayedVisibilityTimeout, setDelayedVisibilityTimeout] = React.useState();
    const [closingTimeout, setClosingTimeout] = React.useState();
    const hide = React.useCallback(() => {
        clearTimeout(closingTimeout);
        setClosing(true);
        setClosingTimeout(setTimeout(() => {
            setClosing(false);
            setSnackbar(undefined);
            setClosingTimeout(undefined);
            setUniqueId(undefined);
        }, CLOSING_DELAY));
    }, [closingTimeout]);
    const show = React.useCallback((options = {}) => {
        const delay = options?.delay || DEFAULT_DELAY;
        clearTimeout(visibilityTimeout);
        clearTimeout(delayedVisibilityTimeout);
        if (snackbar) {
            hide();
            setDelayedVisibilityTimeout(setTimeout(() => {
                setSnackbar(options);
                setUniqueId(getUniqueId());
            }, CLOSING_DELAY));
            setVisibilityTimeout(setTimeout(() => {
                hide();
                setVisibilityTimeout(undefined);
            }, delay + CLOSING_DELAY));
        }
        else {
            setSnackbar(options);
            setUniqueId(getUniqueId());
            setVisibilityTimeout(setTimeout(() => {
                hide();
                setVisibilityTimeout(undefined);
            }, delay));
        }
    }, [delayedVisibilityTimeout, hide, snackbar, visibilityTimeout]);
    return (_jsxs(SnackbarContext.Provider, { value: { show, hide }, children: [children, snackbar && (_jsx(Snackbar, { ...snackbar, closing: closing, close: hide }, uniqueId))] }));
}
function getUniqueId() {
    return Math.floor((1 + Math.random()) * 0x10000);
}
