"use client";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import classNames from "classnames";
import Loader from "../loader";
import CheckIcon from "../icons/check";
import css from "../input/input.module.css";
export default function Select({ label = "", icon, options = [], className, valid, error, patternError, compact, loading, value, placeholder, onChange, onValueChange, ...props }) {
    const [touched, setTouched] = React.useState(false);
    const isValid = valid && !error;
    const _onChange = (e) => {
        onChange?.(e);
        onValueChange?.(e.target.value);
    };
    const handleBlur = (e) => {
        setTouched(true);
        props.onBlur?.(e);
    };
    const Icon = icon ? icon : null;
    const classes = classNames(css.select, className, {
        [css.touched]: touched,
        [css.withIcon]: !!Icon,
        [css.compact]: compact,
        [css.valid]: isValid,
        [css.error]: error,
    });
    return (_jsxs("div", { className: classes, children: [_jsxs("label", { className: css.label, children: [(label || isValid) && (_jsxs("span", { className: css.labelText, children: [label, isValid && _jsx(CheckIcon, { className: css.validIndicator })] })), _jsxs("div", { className: css.fieldWrapper, children: [Icon && _jsx(Icon, {}), _jsxs("select", { className: css.field, value: value, onChange: _onChange, "aria-invalid": isValid !== undefined && !isValid, ...props, disabled: loading || props.disabled, onBlur: handleBlur, children: [placeholder && _jsx("option", { value: "", children: placeholder }), options.map((option) => {
                                        if (typeof option === "string") {
                                            return (_jsx("option", { value: option, children: option }, option));
                                        }
                                        const { label, value, disabled } = option;
                                        return (_jsx("option", { value: value, disabled: disabled, children: label }, value));
                                    })] }), loading && _jsx(Loader, { variant: "overlay", className: css.loader })] })] }), patternError && (_jsx("div", { className: css.patternErrorMessage, children: patternError })), error && (_jsx("div", { className: css.errorMessage, role: "alert", children: error }))] }));
}
export function formatOptions(labelKey, valueKey, collection) {
    if (!collection)
        return [];
    return collection.map((item) => ({
        label: String(item[labelKey]),
        value: String(item[valueKey]),
    }));
}
