import * as React from "react";
type Option = string | {
    label: string;
    value: string;
    disabled?: boolean;
};
type Props = React.InputHTMLAttributes<HTMLSelectElement> & {
    label?: React.ReactNode;
    icon?: React.FC<React.SVGProps<SVGSVGElement>>;
    options: Option[];
    valid?: boolean;
    error?: boolean | string;
    patternError?: string;
    compact?: boolean;
    loading?: boolean;
    onValueChange?: (value: string) => void;
};
export default function Select({ label, icon, options, className, valid, error, patternError, compact, loading, value, placeholder, onChange, onValueChange, ...props }: Props): import("react/jsx-runtime").JSX.Element;
export declare function formatOptions(labelKey: string, valueKey: string, collection?: Record<string, string | number | boolean>[]): {
    label: string;
    value: string;
}[];
export {};
//# sourceMappingURL=select.d.ts.map