import * as React from "react";
import * as Ripple from "./ripple";
export default function useRippleEffect(...selectors) {
    const down = React.useRef(false);
    const selector = selectors.join(", ");
    const mouseDowned = (e) => {
        Ripple.create(e);
    };
    const keyDowned = (e) => {
        if (!down.current && (e.code === "Space" || e.code === "Enter")) {
            Ripple.create(e);
        }
        down.current = true;
    };
    const keyUp = () => {
        down.current = false;
    };
    React.useEffect(() => {
        const elements = Array.from(document.querySelectorAll(selector));
        elements.forEach((element) => {
            element.addEventListener("mousedown", mouseDowned);
            element.addEventListener("keydown", keyDowned);
            element.addEventListener("keyup", keyUp);
        });
        return () => {
            elements.forEach((element) => {
                element.removeEventListener("keyup", keyUp);
                element.removeEventListener("keydown", keyDowned);
                element.removeEventListener("mousedown", mouseDowned);
            });
        };
    }, [selector]);
}
