import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as RadioGroupPrimitive from "@radix-ui/react-radio-group";
import classNames from "classnames";
import styles from "./radio-group.module.css";
export default function RadioGroup({ items, defaultValue, onValueChange, disabled, value, ...props }) {
    return (_jsx("div", { children: _jsx(RadioGroupPrimitive.Root, { className: styles.radioGroupRoot, defaultValue: defaultValue, onValueChange: onValueChange, value: value, disabled: disabled, ...props, children: items.map(({ label, value, disabled: itemDisabled }) => {
                const itemClasses = classNames(styles.radioRow, {
                    [styles.radioRowDisabled]: itemDisabled,
                });
                return (_jsxs("div", { className: itemClasses, children: [_jsx(RadioGroupPrimitive.Item, { className: styles.radioGroupItem, value: value, id: value, disabled: itemDisabled, children: _jsx(RadioGroupPrimitive.Indicator, { className: styles.radioGroupIndicator }) }), _jsx("label", { className: styles.label, htmlFor: value, children: label })] }, value));
            }) }) }));
}
