"use client";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import classNames from "classnames";
import * as PopoverPrimitive from "@radix-ui/react-popover";
import Button from "../button";
import CloseIcon from "../icons/close";
import styles from "./popover.module.css";
export default React.forwardRef(Popover);
export { PopoverPrimitive };
function Popover({ className, innerClassName, trigger, showCloseButton, open, onOpenChange, contentProps = {}, hideArrow, children, }, ref) {
    const classes = classNames(styles.content, className, innerClassName);
    return (_jsxs(PopoverPrimitive.Root, { open: open, onOpenChange: onOpenChange, children: [_jsx(PopoverPrimitive.Trigger, { asChild: true, children: trigger }), _jsx(PopoverPrimitive.Portal, { children: _jsxs(PopoverPrimitive.Content, { ref: ref, className: classes, collisionPadding: 6, sideOffset: 5, ...contentProps, children: [children, showCloseButton && (_jsx(PopoverPrimitive.Close, { className: styles.close, asChild: true, children: _jsx(Button, { variant: "transparent", compact: true, children: _jsx(CloseIcon, {}) }) })), !hideArrow && _jsx(PopoverPrimitive.Arrow, { className: styles.arrow })] }) })] }));
}
