"use client";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import classNames from "classnames";
import Button from "../button";
import Input from "../input";
import MinusIcon from "../icons/minus";
import PlusIcon from "../icons/plus";
import css from "./number-picker.module.css";
export default function NumberPicker({ label, className, min = 0, max = Infinity, value, disabled, onChange, withInput, compact, }) {
    const classes = classNames(css.picker, className, {
        [css.active]: value > 0,
        [css.disabled]: disabled,
        [css.withInput]: withInput,
        [css.compact]: compact,
    });
    const valueLength = value.toString().length;
    const inputSize = valueLength < 2 ? 2 : valueLength;
    return (_jsxs("div", { className: classes, children: [label && _jsx("div", { className: css.label, children: label }), _jsxs("div", { className: css.inner, children: [_jsx(Button, { variant: "secondary", onClick: subtract(value, min, max, onChange), disabled: isBelow(value, min, disabled), "aria-label": "Minus", compact: compact, children: _jsx(MinusIcon, {}) }), withInput ? (_jsx(Input, { type: "text", value: value, onValueChange: update(min, max, onChange), className: css.value, disabled: disabled, size: inputSize, compact: compact, inputMode: "numeric" })) : (_jsx("span", { className: css.value, children: value })), _jsx(Button, { variant: "secondary", onClick: add(value, min, max, onChange), disabled: isAbove(value, max, disabled), "aria-label": "Plus", compact: compact, children: _jsx(PlusIcon, {}) })] })] }));
}
function subtract(value, min, max, onChange) {
    return () => {
        changeValue(value, -1, min, max, onChange);
    };
}
function add(value, min, max, onChange) {
    return () => {
        changeValue(value, 1, min, max, onChange);
    };
}
function update(min, max, onChange) {
    return (value) => {
        changeValue(value, 0, min, max, onChange);
    };
}
function changeValue(value, step, min, max, onChange) {
    const newValue = Number(value) + step;
    switch (true) {
        case newValue >= min && newValue <= max:
            onChange(newValue);
            break;
        case newValue < min:
            onChange(min);
            break;
        case newValue > max:
            onChange(max);
            break;
    }
}
function isBelow(val, min, disabled) {
    return disabled || val <= min;
}
function isAbove(val, max, disabled) {
    return disabled || val >= max;
}
