"use client";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import classNames from "classnames";
import Loader from "../loader";
import Checkbox from "../checkbox";
import Dropdown from "../dropdown";
import Input from "../input";
import CheckIcon from "../icons/check";
import css from "./multiple-select.module.css";
import SearchIcon from "../icons/search";
import cssInput from "../input/input.module.css";
export default function MultipleSelect({ label = "", icon, options = [], values = [], className, valid, error, compact, loading, disabled, onChange, withSearch = false, defaultOpened = false, onOpen, uniqueChoice = false, ...props }) {
    const ref = React.useRef(null);
    const inputRef = React.useRef(null);
    const dropdownRef = React.useRef(null);
    const [opened, setOpened] = React.useState(defaultOpened);
    const [search, setSearch] = React.useState("");
    const isValid = valid && !error;
    const filteredOptions = options.filter((option) => {
        const isString = typeof option === "string";
        const label = isString ? option : option.label;
        return label.toLowerCase().includes(search.toLowerCase());
    });
    const _onChange = (option) => () => {
        const newValues = getNewValues(option, values, uniqueChoice);
        onChange?.(newValues);
        if (uniqueChoice) {
            closeDropdown();
        }
    };
    const handleSpaceKeyPress = (e) => {
        if (e.code === "Space") {
            e.preventDefault();
            e.stopPropagation();
            inputRef.current?.click();
        }
    };
    const Icon = icon || null;
    const valueLabel = values
        .map((value) => {
        const isString = typeof value === "string";
        if (isString)
            return value;
        return value.label;
    })
        .sort((a, b) => {
        const indexOfA = options.findIndex((option) => {
            const isString = typeof option === "string";
            return isString ? a === option : a === option.label;
        });
        const indexOfB = options.findIndex((option) => {
            const isString = typeof option === "string";
            return isString ? b === option : b === option.label;
        });
        return indexOfA - indexOfB;
    })
        .join(", ");
    const toggleDropdown = (e) => {
        const newOpenedValue = !opened;
        setOpened(newOpenedValue);
        onOpen?.(newOpenedValue);
        props?.onClick?.(e);
    };
    const closeDropdown = (e) => {
        const target = e?.target;
        if (target && ref.current?.contains(target))
            return;
        setOpened(false);
        onOpen?.(false);
    };
    const isDisabled = loading || disabled;
    const classes = classNames(cssInput.select, css.select, className, {
        [cssInput.withIcon]: !!Icon,
        [cssInput.compact]: compact,
        [cssInput.valid]: isValid,
        [cssInput.error]: error,
        [cssInput.disabled]: isDisabled,
        [css.opened]: opened,
    });
    return (_jsxs("div", { ref: ref, className: classes, children: [_jsxs("label", { className: cssInput.label, children: [(label || isValid) && (_jsxs("span", { className: cssInput.labelText, children: [label, isValid && _jsx(CheckIcon, { className: cssInput.validIndicator })] })), _jsx(Dropdown, { ref: dropdownRef, onClose: closeDropdown, title: label, open: opened, content: _jsxs("div", { className: css.dropdownInner, children: [withSearch && (_jsx(Input, { className: css.search, icon: SearchIcon, value: search, onValueChange: setSearch, compact: true })), filteredOptions.map((option) => {
                                    const isString = typeof option === "string";
                                    const label = isString ? option : option.label;
                                    const value = isString ? option : option.value;
                                    const disabled = !isString && option.disabled;
                                    const isSelected = values.find((o) => {
                                        const isString = typeof o === "string";
                                        return isString ? o === value : o.value === value;
                                    });
                                    const classes = classNames(css.option, {
                                        [css.optionSelected]: isSelected,
                                    });
                                    return (_jsx("div", { role: "listitem", children: _jsx(Checkbox, { label: label, className: classes, checked: !!isSelected, onChange: _onChange(option), disabled: disabled, tabIndex: opened ? 0 : -1 }) }, value));
                                })] }), children: _jsxs("div", { className: cssInput.fieldWrapper, children: [Icon && _jsx(Icon, {}), _jsx("input", { ref: inputRef, type: "text", className: cssInput.field, value: valueLabel, "aria-invalid": isValid !== undefined && !isValid, ...props, onClick: toggleDropdown, disabled: isDisabled, onKeyDown: handleSpaceKeyPress, readOnly: true }), loading && (_jsx(Loader, { variant: "overlay", className: cssInput.loader }))] }) })] }), error && (_jsx("div", { className: cssInput.errorMessage, role: "alert", children: error }))] }));
}
function getNewValues(option, values, uniqueChoice) {
    const isString = typeof option === "string";
    const value = isString ? option : option.value;
    const isSelected = values.some((o) => {
        const isString = typeof o === "string";
        return isString ? o === value : o.value === value;
    });
    if (uniqueChoice) {
        return isSelected ? [] : [option];
    }
    return isSelected
        ? values.filter((v) => {
            const isString = typeof v === "string";
            return isString ? v !== value : v.value !== value;
        })
        : [...values, option];
}
