import * as React from "react";
export type Option = string | {
    label: string;
    value: string;
    disabled?: boolean;
};
type Props = Omit<React.InputHTMLAttributes<HTMLInputElement>, "onChange"> & {
    label?: React.ReactNode;
    icon?: React.FC<React.SVGProps<SVGSVGElement>>;
    options: Option[];
    values: Option[];
    className?: string;
    valid?: boolean;
    error?: boolean | string;
    compact?: boolean;
    loading?: boolean;
    disabled?: boolean;
    onChange: (values: Option[]) => void;
    defaultOpened?: boolean;
    placeholder?: string;
    onOpen?: (opened: boolean) => void;
    uniqueChoice?: boolean;
    withSearch?: boolean;
};
export default function MultipleSelect({ label, icon, options, values, className, valid, error, compact, loading, disabled, onChange, withSearch, defaultOpened, onOpen, uniqueChoice, ...props }: Props): import("react/jsx-runtime").JSX.Element;
export {};
//# sourceMappingURL=multiple-select.d.ts.map