export function triggerInputChange(node, value) {
    const inputTypes = [
        window.HTMLInputElement,
        window.HTMLSelectElement,
        window.HTMLTextAreaElement,
    ];
    if (inputTypes.indexOf(Object.getPrototypeOf(node).constructor) > -1) {
        const setValue = Object.getOwnPropertyDescriptor(Object.getPrototypeOf(node), "value")?.set;
        const event = new Event("input", { bubbles: true });
        if (setValue) {
            setValue.call(node, value);
            node.dispatchEvent(event);
        }
    }
}
