"use client";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import classNames from "classnames";
import Loader from "../loader";
import DateInput from "./date-input";
import CheckIcon from "../icons/check";
import css from "./input.module.css";
export default React.forwardRef(Input);
function Input({ type = "text", label = "", icon, className, valid, error, patternError, compact, loading, value, options, onChange, onValueChange, ...props }, fieldRef) {
    const _ref = React.useRef(null);
    const ref = fieldRef ?? _ref;
    const inputRef = React.useRef(null);
    const [touched, setTouched] = React.useState(false);
    const listId = React.useId();
    const allowOptions = type === "text" && options !== undefined;
    const isDate = type === "date";
    const isValid = valid && !error;
    const _onChange = (e) => {
        onChange?.(e);
        onValueChange?.(e.target.value);
    };
    const handleSpaceKeyPress = (e) => {
        if (props.readOnly && e.code === "Space") {
            e.preventDefault();
            e.stopPropagation();
            inputRef.current?.click();
        }
        props.onKeyDown?.(e);
    };
    const handleBlur = (e) => {
        const value = e.target.value;
        if (value.trim().length > 0) {
            setTouched(true);
        }
        props.onBlur?.(e);
    };
    const Icon = icon || null;
    const classes = classNames(css.input, className, {
        [css.touched]: touched,
        [css.withIcon]: !!Icon,
        [css.compact]: compact,
        [css.date]: isDate,
        [css.valid]: isValid,
        [css.error]: error,
    });
    const Label = label ? "label" : "div";
    return (_jsxs("div", { ref: ref, className: classes, children: [_jsxs(Label, { className: css.label, children: [(label || (isValid && !error)) && (_jsxs("span", { className: css.labelText, children: [label, isValid && !error && _jsx(CheckIcon, { className: css.validIndicator })] })), isDate ? (_jsx(DateInput, { inputRef: inputRef, label: label, onChange: _onChange, value: value, loading: loading, compact: compact, setTouched: setTouched, ...props })) : (_jsxs("div", { className: css.fieldWrapper, children: [Icon && _jsx(Icon, {}), _jsx("input", { ref: inputRef, type: type, className: css.field, value: value, onChange: _onChange, "aria-invalid": isValid !== undefined && !isValid, ...props, disabled: loading || props.disabled, autoComplete: allowOptions ? "off" : undefined, list: allowOptions ? listId : undefined, onKeyDown: handleSpaceKeyPress, onBlur: isDate ? undefined : handleBlur }), allowOptions && (_jsx("datalist", { id: listId, children: options.map((option) => (_jsx("option", { value: option }, option))) })), loading && _jsx(Loader, { variant: "overlay", className: css.loader })] }))] }), patternError && (_jsx("div", { className: css.patternErrorMessage, children: patternError })), error && (_jsx("div", { className: css.errorMessage, role: "alert", children: error }))] }));
}
