import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import DatePicker from "../date-picker";
import Input from "./input";
import Dropdown from "../dropdown";
import * as Utils from "./utils";
import VisuallyHidden from "../visually-hidden";
import * as DateUtils from "../date-picker/utils";
import CalendarIcon from "../icons/calendar";
import css from "./input.module.css";
export default function DateInput({ inputRef, value, hint, min, max, label, icon, placeholder = "JJ/MM/AAAA", compact, loading, onChange, onDisplayedMonthChange, defaultMonth, defaultYear, decorators, extended, setTouched, ...props }) {
    const ref = React.useRef(null);
    const dropdownRef = React.useRef(null);
    const [uncontrolledValue, setUncontrolledValue] = React.useState(props.defaultValue || "");
    const [datePickerVisible, setDatePickerVisible] = React.useState(false);
    const dateValue = value && DateUtils.createGMTDate(value);
    const uncontrolledDateValue = uncontrolledValue && DateUtils.createGMTDate(uncontrolledValue);
    const _onChange = (value) => {
        if (inputRef.current) {
            Utils.triggerInputChange(inputRef.current, value);
            setUncontrolledValue(value || "");
            setDatePickerVisible(false);
            setTouched?.(true);
        }
    };
    const forwardFocus = () => {
        if (ref.current) {
            ref.current.focus();
        }
    };
    const closeDropdown = (e) => {
        const target = e?.target;
        if (target && ref.current?.contains(target))
            return;
        setDatePickerVisible(false);
    };
    const handleOpenChange = (open) => {
        setDatePickerVisible(open);
    };
    const toggleDatePicker = (e) => {
        setDatePickerVisible(!datePickerVisible);
        props.onClick?.(e);
    };
    const inputValue = dateValue || uncontrolledDateValue;
    const formattedValue = inputValue
        ? inputValue.toLocaleDateString("fr-FR")
        : "";
    return (_jsxs(_Fragment, { children: [_jsx(VisuallyHidden, { asChild: true, children: _jsx("input", { className: css.hidden, ref: inputRef, type: "text", value: value, defaultValue: value === undefined ? uncontrolledValue : undefined, onChange: onChange, onFocus: forwardFocus, name: props.name, required: props.required, pattern: props.pattern }) }), _jsx(Dropdown, { ref: dropdownRef, className: css.dateDropdown, innerClassName: css.dateDropdownInner, title: label, onClose: closeDropdown, open: datePickerVisible, onOpenChange: handleOpenChange, content: _jsx(DatePicker, { className: css.datePicker, min: min, max: max, value: (value || uncontrolledValue), hint: hint, onChange: _onChange, onDisplayedMonthChange: onDisplayedMonthChange, defaultMonth: defaultMonth, defaultYear: defaultYear, decorators: decorators, extended: extended }), children: _jsx(Input, { ref: ref, type: "text", icon: icon || CalendarIcon, className: css.dateField, onClick: toggleDatePicker, value: formattedValue, placeholder: placeholder, compact: compact, ...props, readOnly: true, loading: loading, required: undefined, defaultValue: undefined, onChange: undefined, name: undefined, pattern: undefined }) })] }));
}
