import * as React from "react";
type Props = React.InputHTMLAttributes<HTMLInputElement> & {
    inputRef: React.RefObject<HTMLInputElement | null>;
    label?: React.ReactNode;
    icon?: React.FC<React.SVGProps<SVGSVGElement>>;
    hint?: string;
    placeholder?: string;
    compact?: boolean;
    loading?: boolean;
    defaultMonth?: number;
    defaultYear?: number;
    onChange?: (e: React.ChangeEvent<HTMLInputElement>) => void;
    onValueChange?: (value: string) => void;
    onDisplayedMonthChange?: (data: {
        firstDisplayedDay: string;
        month: number;
        year: number;
    }) => void;
    decorators?: Record<string, React.ComponentType<{
        children: React.ReactNode;
    }>>;
    extended?: boolean;
    setTouched?: (touched: boolean) => void;
};
export default function DateInput({ inputRef, value, hint, min, max, label, icon, placeholder, compact, loading, onChange, onDisplayedMonthChange, defaultMonth, defaultYear, decorators, extended, setTouched, ...props }: Props): import("react/jsx-runtime").JSX.Element;
export {};
//# sourceMappingURL=date-input.d.ts.map