import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import classNames from "classnames";
import Button from "../button";
import InfoCircleIcon from "../icons/info-circle";
import CheckCircleIcon from "../icons/check-circle";
import AlertTriangleIcon from "../icons/alert-triangle";
import AlertCircleIcon from "../icons/alert-circle";
import CloseIcon from "../icons/close";
import styles from "./information.module.css";
const DEFAULT_ICONS = {
    default: InfoCircleIcon,
    info: InfoCircleIcon,
    success: CheckCircleIcon,
    warning: AlertTriangleIcon,
    error: AlertCircleIcon,
};
export default function Information({ type = "default", icon, className, close, children, }) {
    const classes = classNames(styles.information, className, {
        [styles[type]]: type,
    });
    const Icon = icon || DEFAULT_ICONS[type];
    return (_jsxs("div", { className: classes, children: [_jsx(Icon, { className: styles.icon }), _jsx("div", { className: styles.content, children: children }), Boolean(close) && (_jsx(Button, { className: styles.close, variant: "transparent", onClick: close, children: _jsx(CloseIcon, {}) }))] }));
}
