import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import * as Portal from "@radix-ui/react-portal";
import classNames from "classnames";
import Button from "../button";
import css from "./panel.module.css";
export default React.forwardRef(Panel);
function Panel({ title, className, innerClassName, onClose, children }, ref) {
    const innerRef = React.useRef(null);
    const [closed, setClosed] = React.useState(false);
    const [dragStart, setDragStart] = React.useState();
    const [dragValue, setDragValue] = React.useState();
    const startDragging = (e) => {
        const isMouseDown = e.type === "mousedown";
        const { clientY: y } = isMouseDown ? e : e.targetTouches[0];
        setDragStart(y);
    };
    const updateDragging = (e) => {
        if (!dragStart) {
            setDragValue(undefined);
            return;
        }
        const isMouseMove = e.type === "mousemove";
        const { clientY: y } = isMouseMove ? e : e.targetTouches[0];
        const delta = Math.max(0, y - dragStart);
        setDragValue(delta);
    };
    const handleClose = () => {
        onClose?.();
    };
    const endDragging = () => {
        const inner = innerRef?.current;
        if (!inner)
            return;
        stopDragging();
        const closeDistance = inner.clientHeight / 2;
        if (dragValue && dragValue > closeDistance) {
            setClosed(true);
            setTimeout(() => {
                handleClose();
            }, 160);
        }
    };
    const stopDragging = () => {
        setDragStart(undefined);
        setDragValue(undefined);
    };
    const panelStyles = dragValue
        ? { transform: `translateY(${dragValue}px)`, transition: "none" }
        : undefined;
    const classes = classNames(css.panel, className, {
        [css.closed]: closed,
    });
    const backdropClasses = classNames(css.backdrop, {
        [css.hasCloseCallback]: typeof onClose === "function",
    });
    const innerClasses = classNames(css.inner, innerClassName);
    return (_jsxs(Portal.Root, { style: { pointerEvents: "auto" }, onClick: (e) => e.stopPropagation(), children: [_jsx("div", { className: backdropClasses, onClick: handleClose }), _jsxs("div", { ref: ref, className: classes, style: panelStyles, onMouseMove: updateDragging, onTouchMove: updateDragging, onMouseLeave: stopDragging, onMouseUp: endDragging, onTouchEnd: endDragging, children: [_jsx(Button, { variant: "transparent", className: css.handleContainer, onTouchStart: startDragging, onMouseDown: startDragging, onMouseUp: endDragging, noRipple: true, children: _jsx("div", { className: css.handle }) }), _jsxs("div", { ref: innerRef, className: innerClasses, children: [title && _jsx("span", { className: css.title, children: title }), children] })] })] }));
}
