"use client";
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import Panel from "./panel";
import useWindowDimensions from "../lib/hooks/use-window-dimensions";
import Popover from "../popover";
export default React.forwardRef(Dropdown);
function Dropdown({ title, className, innerClassName, breakpoint = 480, onClose, open, onOpenChange, content, hideArrow, popoverContentProps = {}, children, }, ref) {
    const { width: windowWidth } = useWindowDimensions();
    const displayMode = windowWidth && windowWidth <= breakpoint ? "panel" : "dropdown";
    const isInPanelMode = displayMode === "panel";
    const contentProps = {
        ...popoverContentProps,
        onClick: (e) => {
            e.stopPropagation();
            popoverContentProps?.onClick?.(e);
        },
        onPointerDownOutside: (e) => {
            onClose?.(e);
            popoverContentProps?.onPointerDownOutside?.(e);
        },
    };
    return isInPanelMode ? (_jsxs(_Fragment, { children: [children, open && (_jsx(Panel, { ref: ref, title: title, className: className, innerClassName: innerClassName, onClose: onClose, children: content }))] })) : (_jsx(Popover, { ref: ref, trigger: children, className: className, innerClassName: innerClassName, open: open, onOpenChange: onOpenChange, contentProps: contentProps, hideArrow: hideArrow, children: content }));
}
