import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import classNames from "classnames";
import * as DropdownMenuPrimitive from "@radix-ui/react-dropdown-menu";
import styles from "./dropdown-menu.module.css";
import Button from "../button";
export default function DropdownMenu({ items, className, open, onOpenChange, modal, contentProps = {}, hideArrow, children, }) {
    const classes = classNames(styles.content, className);
    return (_jsxs(DropdownMenuPrimitive.Root, { open: open, onOpenChange: onOpenChange, modal: modal, children: [_jsx(DropdownMenuPrimitive.Trigger, { asChild: true, children: children }), _jsx(DropdownMenuPrimitive.Portal, { children: _jsxs(DropdownMenuPrimitive.Content, { className: classes, collisionPadding: 6, sideOffset: 5, ...contentProps, children: [items?.map(({ label, onClick, separator, className }, i) => {
                            const itemClasses = classNames(styles.item, className);
                            return (_jsxs(React.Fragment, { children: [separator === "before" && (_jsx(DropdownMenuPrimitive.Separator, { className: styles.separator })), _jsx(DropdownMenuPrimitive.Item, { className: itemClasses, onClick: onClick, asChild: true, children: _jsx(Button, { variant: "transparent", children: label }) }), separator === "after" && (_jsx(DropdownMenuPrimitive.Separator, { className: styles.separator }))] }, i));
                        }), !hideArrow && (_jsx(DropdownMenuPrimitive.Arrow, { className: styles.arrow }))] }) })] }));
}
