"use client";
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import * as DialogPrimitive from "@radix-ui/react-dialog";
import classNames from "classnames";
import Loader from "../loader";
import Button from "../button";
import Portal from "../portal";
import VisuallyHidden from "../visually-hidden";
import CloseIcon from "../icons/close";
import css from "./dialog.module.css";
export default function Dialog({ className, style, title = "", description = "", close, isOpened, showCloseButton = true, closeButtonVariant = "primary", closeOnBackdropClick = true, disableBackdrop, container = "body", showAsModal = true, dialogRef, loading, children, }) {
    const _ref = React.useRef(null);
    const ref = dialogRef ?? _ref;
    const [mounted, setMounted] = React.useState(false);
    React.useEffect(() => {
        setMounted(true);
    }, []);
    if (!mounted)
        return null;
    const parent = container
        ? document.querySelector(container)
        : undefined;
    const contentClasses = classNames(css.content, className, {
        [css.loading]: loading,
    });
    return (_jsxs(_Fragment, { children: [!showAsModal && !disableBackdrop && isOpened && (_jsx(Portal, { container: parent || document.body, asChild: true, children: _jsx("div", { className: css.overlay, onClick: closeOnBackdropClick ? close : undefined }) })), _jsx(DialogPrimitive.Root, { open: isOpened, modal: showAsModal, children: _jsxs(DialogPrimitive.Portal, { container: parent, children: [_jsx(DialogPrimitive.Overlay, { className: css.overlay, onClick: closeOnBackdropClick ? close : undefined }), _jsxs(DialogPrimitive.Content, { ref: ref, className: contentClasses, style: style, onEscapeKeyDown: close, onSubmit: close, children: [!loading && showCloseButton && (_jsx("div", { className: css.header, children: _jsx(DialogPrimitive.Close, { onClick: close, asChild: true, children: _jsx(Button, { className: css.closeButton, variant: closeButtonVariant, children: _jsx(CloseIcon, { className: css.closeIcon }) }) }) })), _jsx(VisuallyHidden, { children: _jsx(DialogPrimitive.Title, { children: title }) }), _jsx(VisuallyHidden, { children: _jsx(DialogPrimitive.Description, { children: description }) }), loading ? _jsx(Loader, {}) : children] })] }) })] }));
}
