import * as Data from "./data";
export function createGMTDate(fromDate) {
    const date = fromDate ? new Date(fromDate) : new Date();
    const day = date.getDate();
    const month = date.getMonth();
    const year = date.getFullYear();
    date.setMinutes(date.getMinutes() + date.getTimezoneOffset());
    date.setHours(0);
    const newDay = date.getDate();
    const newMonth = date.getMonth();
    const newYear = date.getFullYear();
    if (date.getTimezoneOffset() < 0 &&
        (newDay < day || newMonth < month || newYear < year)) {
        date.setDate(date.getDate() + 1);
    }
    return date;
}
export function zeroPad(value, length) {
    return `${value}`.padStart(length, "0");
}
export function getYearsRange(start, end) {
    return Array(end - start + 1)
        .fill(undefined)
        .map((_, i) => start + i)
        .sort((a, b) => b - a);
}
export function getMonthDays(month = Data.THIS_MONTH, year = Data.THIS_YEAR) {
    const months30 = [4, 6, 9, 11];
    const leapYear = year % 4 === 0;
    return month === 2
        ? leapYear
            ? 29
            : 28
        : months30.includes(month)
            ? 30
            : 31;
}
export function getMonthFirstDay(month = Data.THIS_MONTH, year = Data.THIS_YEAR) {
    return createGMTDate(`${year}-${zeroPad(month, 2)}-01`).getDay();
}
export function isDate(date) {
    const isDate = Object.prototype.toString.call(date) === "[object Date]";
    const isValidDate = date && !Number.isNaN(date.valueOf());
    return isDate && isValidDate;
}
export function isSameMonth(date, basedate = createGMTDate()) {
    if (!(isDate(date) && isDate(basedate)))
        return false;
    const basedateMonth = basedate.getMonth() + 1;
    const basedateYear = basedate.getFullYear();
    const dateMonth = date.getMonth() + 1;
    const dateYear = date.getFullYear();
    return basedateMonth === dateMonth && basedateYear === dateYear;
}
export function isSameDay(date, basedate = createGMTDate()) {
    if (!(isDate(date) && isDate(basedate)))
        return false;
    const basedateDate = basedate.getDate();
    const basedateMonth = basedate.getMonth() + 1;
    const basedateYear = basedate.getFullYear();
    const dateDate = date.getDate();
    const dateMonth = date.getMonth() + 1;
    const dateYear = date.getFullYear();
    return (basedateDate === dateDate &&
        basedateMonth === dateMonth &&
        basedateYear === dateYear);
}
export function getPreviousMonth(month, year) {
    const prevMonth = month > 1 ? month - 1 : 12;
    const prevMonthYear = month > 1 ? year : year - 1;
    return { month: prevMonth, year: prevMonthYear };
}
export function getNextMonth(month, year) {
    const nextMonth = month < 12 ? month + 1 : 1;
    const nextMonthYear = month < 12 ? year : year + 1;
    return { month: nextMonth, year: nextMonthYear };
}
