"use client";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import classNames from "classnames";
import CalendarHeader from "./calendar-header";
import CalendarMonth from "./calendar-month";
import * as Data from "./data";
import * as Utils from "./utils";
import css from "./date-picker.module.css";
export default React.forwardRef(DatePicker);
function DatePicker({ lang, className, min, max, extended, value, hint, onChange, onDisplayedMonthChange, defaultMonth, defaultYear, decorators, }, ref) {
    const locale = getLocale(lang);
    const now = Utils.createGMTDate();
    const date = value && Utils.createGMTDate(value);
    const dateMonth = date && date.getMonth() + 1;
    const dateYear = date && date.getFullYear();
    const minDate = min ? Utils.createGMTDate(min) : undefined;
    if (minDate)
        minDate.setHours(0, 0, 0, 0);
    const maxDate = max ? Utils.createGMTDate(max) : undefined;
    if (maxDate)
        maxDate.setHours(0, 0, 0, 0);
    const minMonth = minDate && minDate.getMonth() + 1;
    const minYear = minDate && minDate.getFullYear();
    const currentMonth = now.getMonth() + 1;
    const currentYear = now.getFullYear();
    const [month, setMonth] = React.useState(minMonth || defaultMonth || dateMonth || currentMonth);
    const [year, setYear] = React.useState(minYear || defaultYear || dateYear || currentYear);
    const pastMonthDisabled = (minDate &&
        month <= minDate.getMonth() + 1 &&
        year <= minDate.getFullYear()) ||
        (minDate && !maxDate && month <= currentMonth && year <= currentYear);
    const futureMonthDisabled = (maxDate &&
        month >= maxDate.getMonth() + 1 &&
        year >= maxDate.getFullYear()) ||
        (maxDate && !minDate && month >= currentMonth && year >= currentYear);
    const i18nMonths = Data.MONTHS[locale];
    const monthName = i18nMonths[Object.keys(i18nMonths)[month - 1]];
    const i18nWeekDays = Data.WEEK_DAYS[locale];
    const days = Object.keys(i18nWeekDays);
    const secondMonth = getSecondMonth(month, year);
    const calendarDates = Data.calendar(month, year);
    const secondCalendarDates = extended && Data.calendar(secondMonth.month, secondMonth.year);
    const goToPreviousMonth = () => {
        const { month: newMonth, year: newYear } = Utils.getPreviousMonth(month, year);
        setMonth(newMonth);
        setYear(newYear);
    };
    const goToNextMonth = () => {
        const { month: newMonth, year: newYear } = Utils.getNextMonth(month, year);
        setMonth(newMonth);
        setYear(newYear);
    };
    const minYearMarker = minDate?.getFullYear() || currentYear - 122;
    const maxYearMarker = maxDate?.getFullYear() || currentYear + 122;
    const months = Data.MONTHS[locale];
    const yearRange = Utils.getYearsRange(minYearMarker, maxYearMarker);
    const monthNames = Object.keys(months).map((key) => months[key]);
    const availableMonths = monthNames.filter((_, i) => {
        return ((minDate && year === minYearMarker && i + 1 >= minDate?.getMonth() + 1) ||
            (maxDate && year === maxYearMarker && i + 1 <= maxDate?.getMonth() + 1) ||
            (year > minYearMarker && year < maxYearMarker));
    });
    React.useEffect(() => {
        if (!availableMonths.includes(monthName)) {
            setMonth(monthNames.indexOf(availableMonths[0]) + 1);
        }
    }, [availableMonths, monthName, monthNames]);
    React.useEffect(() => {
        onDisplayedMonthChange?.({
            firstDisplayedDay: calendarDates[0],
            month,
            year,
        });
    }, [calendarDates, month, onDisplayedMonthChange, year]);
    const classes = classNames(css.root, className);
    return (_jsx("div", { ref: ref, className: classes, children: _jsxs("div", { className: css.inner, children: [_jsx(CalendarHeader, { goToPreviousMonth: goToPreviousMonth, goToNextMonth: goToNextMonth, monthName: monthName, year: year, yearRange: yearRange, monthNames: monthNames, availableMonths: availableMonths, setMonth: setMonth, setYear: setYear, pastMonthDisabled: Boolean(pastMonthDisabled), futureMonthDisabled: Boolean(futureMonthDisabled), extended: extended }), _jsxs("div", { className: css.months, children: [_jsx(CalendarMonth, { locale: locale, calendarDates: calendarDates, days: days, i18nWeekDays: i18nWeekDays, month: month, year: year, value: value, hint: hint, onChange: onChange, minDate: minDate, maxDate: maxDate, decorators: decorators, extended: extended }), secondCalendarDates && (_jsx(CalendarMonth, { locale: locale, calendarDates: secondCalendarDates, days: days, i18nWeekDays: i18nWeekDays, month: secondMonth.month, year: secondMonth.year, value: value, hint: hint, onChange: onChange, minDate: minDate, maxDate: maxDate, decorators: decorators, extended: extended }))] })] }) }));
}
function getSecondMonth(month, year) {
    if (month === 12) {
        return { month: 1, year: year + 1 };
    }
    return { month: month + 1, year };
}
function getLocale(defaultLang) {
    const isBrowser = typeof window !== "undefined";
    let currentLang = defaultLang || "fr";
    if (!defaultLang && isBrowser) {
        const documentLang = (document.documentElement.getAttribute("lang") ||
            navigator?.language);
        if (documentLang) {
            currentLang = documentLang;
        }
    }
    return currentLang === "fr" || currentLang === "fr-FR" ? "fr" : "en";
}
