import * as Utils from "./utils";
export const MODES = {
    SATURDAY: 0,
    SUNDAY: 1,
    CUSTOM: 2,
};
export const DISPLAYS = {
    DESKTOP: 0,
    TABLET: 1,
    PHONE: 2,
};
export const BREAKPOINTS = {
    TABLET: 955,
    PHONE: 650,
};
export const THIS_YEAR = Utils.createGMTDate().getFullYear();
export const THIS_MONTH = Utils.createGMTDate().getMonth() + 1;
export const MONTHS = {
    fr: {
        january: "Janvier",
        february: "Février",
        march: "Mars",
        april: "Avril",
        may: "Mai",
        june: "Juin",
        july: "Juillet",
        august: "Aout",
        september: "Septembre",
        october: "Octobre",
        november: "Novembre",
        december: "Décembre",
    },
    en: {
        january: "January",
        february: "February",
        march: "March",
        april: "April",
        may: "May",
        june: "June",
        july: "July",
        august: "August",
        september: "September",
        october: "October",
        november: "November",
        december: "December",
    },
    it: {
        january: "Gennaio",
        february: "Febbraio",
        march: "Marzo",
        april: "Aprile",
        may: "Maggio",
        june: "Giugno",
        july: "Luglio",
        august: "Agosto",
        september: "Settembre",
        october: "Ottobre",
        november: "Novembre",
        december: "Dicembre",
    },
    es: {
        january: "Enero",
        february: "Febrero",
        march: "Marzo",
        april: "Abril",
        may: "Mayo",
        june: "Junio",
        july: "Julio",
        august: "Agosto",
        september: "Septiembre",
        october: "Octubre",
        november: "Noviembre",
        december: "Diciembre",
    },
    ca: {
        january: "Gener",
        february: "Febrer",
        march: "Març",
        april: "Abril",
        may: "Maig",
        june: "Juny",
        july: "Juliol",
        august: "Agost",
        september: "Setembre",
        october: "Octubre",
        november: "Novembre",
        december: "Desembre",
    },
    nl: {
        january: "Januari",
        february: "Februari",
        march: "Maart",
        april: "April",
        may: "Mei",
        june: "Juni",
        july: "Juli",
        august: "Augustus",
        september: "September",
        october: "Oktober",
        november: "November",
        december: "December",
    },
};
export const WEEK_DAYS = {
    fr: {
        monday: "Lun.",
        tuesday: "Mar.",
        wednesday: "Mer.",
        thursday: "Jeu.",
        friday: "Ven.",
        saturday: "Sam.",
        sunday: "Dim.",
    },
    en: {
        monday: "Mon.",
        tuesday: "Tue",
        wednesday: "Wed.",
        thursday: "Tue.",
        friday: "Fri.",
        saturday: "Sat.",
        sunday: "Sun.",
    },
    it: {
        monday: "Lun.",
        tuesday: "Mar.",
        wednesday: "Mer.",
        thursday: "Gio.",
        friday: "Ven.",
        saturday: "Sab.",
        sunday: "Dom.",
    },
    es: {
        monday: "Lun.",
        tuesday: "Mar.",
        wednesday: "Mie.",
        thursday: "Jue.",
        friday: "Vie.",
        saturday: "Sab.",
        sunday: "Dom.",
    },
    ca: {
        monday: "Dill.",
        tuesday: "Dim.",
        wednesday: "Dm.",
        thursday: "Dj.",
        friday: "Dv.",
        saturday: "Ds.",
        sunday: "Dg.",
    },
    nl: {
        monday: "Ma.",
        tuesday: "Di.",
        wednesday: "Wo.",
        thursday: "Do.",
        friday: "Vr.",
        saturday: "Za.",
        sunday: "Zo.",
    },
};
export const CALENDAR_WEEKS = 6;
export function calendar(month = THIS_MONTH, year = THIS_YEAR) {
    const monthDays = Utils.getMonthDays(month, year);
    const monthFirstDay = Utils.getMonthFirstDay(month, year);
    const daysFromPrevMonth = monthFirstDay === 0 ? 6 : monthFirstDay - 1;
    const daysFromNextMonth = CALENDAR_WEEKS * 7 - (daysFromPrevMonth + monthDays);
    const { month: prevMonth, year: prevMonthYear } = Utils.getPreviousMonth(month, year);
    const { month: nextMonth, year: nextMonthYear } = Utils.getNextMonth(month, year);
    const prevMonthDays = Utils.getMonthDays(prevMonth, prevMonthYear);
    const prevMonthDates = [...new Array(daysFromPrevMonth)].map((_, i) => {
        const day = i + 1 + (prevMonthDays - daysFromPrevMonth);
        return `${prevMonthYear}-${Utils.zeroPad(prevMonth, 2)}-${Utils.zeroPad(day, 2)}`;
    });
    const thisMonthDates = [...new Array(monthDays)].map((_, i) => {
        const day = i + 1;
        return `${year}-${Utils.zeroPad(month, 2)}-${Utils.zeroPad(day, 2)}`;
    });
    const nextMonthDates = [...new Array(daysFromNextMonth)].map((_, i) => {
        const day = i + 1;
        return `${nextMonthYear}-${Utils.zeroPad(nextMonth, 2)}-${Utils.zeroPad(day, 2)}`;
    });
    return [...prevMonthDates, ...thisMonthDates, ...nextMonthDates];
}
