import { jsxs as _jsxs, jsx as _jsx } from "react/jsx-runtime";
import CalendarDate from "./calendar-date";
import * as Data from "./data";
import css from "./calendar-month.module.css";
export default function CalendarMonth({ locale, days, i18nWeekDays, calendarDates, month, year, value, hint, onChange, minDate, maxDate, decorators, extended, }) {
    const i18nMonths = Data.MONTHS[locale];
    const monthName = i18nMonths[Object.keys(i18nMonths)[month - 1]];
    return (_jsxs("div", { className: css.month, children: [extended && (_jsxs("div", { className: css.monthTitle, children: [monthName, " ", year] })), _jsx("div", { className: css.days, children: days.map((day, i) => (_jsx("div", { className: css.day, children: i18nWeekDays[day] }, `${day}-${i}`))) }), _jsx("div", { className: css.dates, children: calendarDates.map((date, i) => {
                    return (_jsx(CalendarDate, { date: date, month: month, year: year, value: value, hint: hint, onChange: onChange, minDate: minDate, maxDate: maxDate, decorator: decorators?.[date], extended: extended }, i));
                }) })] }));
}
