import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import Button from "../button";
import Select from "../select";
import ChevronLeftIcon from "../icons/chevron-left";
import ChevronRightIcon from "../icons/chevron-right";
import css from "./calendar-header.module.css";
export default function Header({ goToPreviousMonth, goToNextMonth, monthName, monthNames, availableMonths, year, yearRange, setMonth, setYear, pastMonthDisabled, futureMonthDisabled, extended, }) {
    const yearSelectLocked = pastMonthDisabled && futureMonthDisabled;
    const updateMonth = (value) => {
        setMonth(monthNames.indexOf(value) + 1);
    };
    const updateYear = (value) => {
        setYear(Number(value));
    };
    const monthOptions = monthNames.map((month) => {
        const isDisabled = !availableMonths.includes(month);
        return {
            value: month,
            label: month,
            disabled: isDisabled,
        };
    });
    return (_jsxs("div", { className: css.header, children: [_jsx(Button, { className: css.control, onClick: goToPreviousMonth, disabled: !!pastMonthDisabled, children: _jsx(ChevronLeftIcon, {}) }), !extended && (_jsxs("div", { className: css.title, children: [_jsx(Select, { value: monthName, options: monthOptions, onValueChange: updateMonth, disabled: pastMonthDisabled && futureMonthDisabled, compact: true }), _jsx(Select, { value: year.toString(), options: yearRange.map((year) => year.toString()), onValueChange: updateYear, compact: true, disabled: yearSelectLocked })] })), _jsx(Button, { className: css.control, onClick: goToNextMonth, disabled: !!futureMonthDisabled, children: _jsx(ChevronRightIcon, {}) })] }));
}
