import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import classNames from "classnames";
import Button from "../button";
import * as Utils from "./utils";
import css from "./calendar-date.module.css";
export default React.memo(CalendarDate);
function CalendarDate({ date, month, year, value, hint, onChange, minDate, maxDate, decorator, extended, }) {
    const _date = Utils.createGMTDate(date);
    _date.setHours(0, 0, 0, 0);
    const isSelected = date === value;
    const isToday = Utils.isSameDay(_date);
    const inMonth = month &&
        year &&
        Utils.isSameMonth(_date, Utils.createGMTDate([Utils.zeroPad(year, 2), Utils.zeroPad(month, 2), "02"].join("-")));
    const isHidden = extended && !inMonth;
    const isDisabled = isHidden || (minDate && _date < minDate) || (maxDate && _date > maxDate);
    const updateDateSelection = () => {
        if (isDisabled)
            return;
        const newValue = value === date ? "" : date;
        onChange(newValue);
    };
    const classes = classNames(css.date, {
        [css.dateToday]: isToday,
        [css.dateSelected]: isSelected,
        [css.dateHint]: date === hint,
        [css.dateNotInMonth]: !inMonth,
        [css.dateHidden]: extended && !inMonth,
        [css.dateDisabled]: isDisabled,
    });
    const Decorator = decorator || EmptyDecorator;
    return (_jsx(Button, { className: classes, onClick: updateDateSelection, disabled: isDisabled, tabIndex: isDisabled ? -1 : undefined, "aria-selected": isSelected ? "true" : undefined, children: _jsx(Decorator, { children: _jsx("span", { children: _date.getDate() }) }) }));
}
function EmptyDecorator({ children }) {
    return children;
}
