import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as React from "react";
import classNames from "classnames";
import * as SelectPrimitive from "@radix-ui/react-select";
import Loader from "../loader";
import CheckIcon from "../icons/check";
import ChevronUpIcon from "../icons/chevron-up";
import ChevronDownIcon from "../icons/chevron-down";
import styles from "./custom-select.module.css";
export default function CustomSelect({ label = "", icon, options = [], className, valid, error, compact, loading, disabled, value, defaultValue, name, required, placeholder, onValueChange, open, defaultOpen, onOpenChange, }) {
    const ref = React.useRef(null);
    const isValid = valid && !error;
    const isDisabled = disabled || loading;
    const Icon = icon || null;
    const classes = classNames(styles.select, className, {
        [styles.withIcon]: !!Icon,
        [styles.compact]: compact,
        [styles.valid]: isValid,
        [styles.error]: error,
    });
    return (_jsxs("div", { className: classes, children: [_jsxs("label", { className: styles.label, children: [(label || isValid) && (_jsxs("span", { className: styles.labelText, children: [label, isValid && _jsx(CheckIcon, { className: styles.validIndicator })] })), _jsxs(SelectPrimitive.Root, { name: name, defaultValue: defaultValue, value: value, onValueChange: onValueChange, open: open, defaultOpen: defaultOpen, onOpenChange: onOpenChange, disabled: isDisabled, required: required, children: [_jsxs(SelectPrimitive.Trigger, { ref: ref, className: styles.trigger, "aria-label": typeof label === "string" ? label : undefined, children: [Icon && _jsx(Icon, { className: styles.icon }), _jsx("span", { className: styles.value, children: _jsx(SelectPrimitive.Value, { placeholder: placeholder }) }), _jsx(SelectPrimitive.Icon, { className: styles.chevrons, children: _jsx(_Fragment, {}) }), loading && _jsx(Loader, { variant: "overlay", className: styles.loader })] }), _jsx(SelectPrimitive.Portal, { children: _jsxs(SelectPrimitive.Content, { className: styles.content, children: [_jsx(SelectPrimitive.ScrollUpButton, { "data-direction": "up", className: styles.scrollButton, children: _jsx(ChevronUpIcon, {}) }), _jsx(SelectPrimitive.Viewport, { className: styles.viewport, children: options.map((option, index) => {
                                                if (typeof option === "string") {
                                                    return (_jsx(SelectItem, { value: option, children: option }, `${option}-${index}`));
                                                }
                                                const { label, value, kind = "item", disabled } = option;
                                                const key = `${index}-${kind}-${value}`;
                                                if (kind === "separator") {
                                                    return (_jsx(SelectPrimitive.Separator, { className: styles.separator }, key));
                                                }
                                                if (kind === "title") {
                                                    return (_jsx(SelectPrimitive.Label, { className: styles.title, children: label }, key));
                                                }
                                                if (!value) {
                                                    return null;
                                                }
                                                return (_jsx(SelectItem, { value: value, disabled: disabled, children: label }, key));
                                            }) }), _jsx(SelectPrimitive.ScrollDownButton, { "data-direction": "down", className: styles.scrollButton, children: _jsx(ChevronDownIcon, {}) })] }) })] })] }), error && (_jsx("div", { className: styles.errorMessage, role: "alert", children: error }))] }));
}
const SelectItem = React.forwardRef(({ children, className, ...props }, forwardedRef) => {
    const classes = classNames(styles.item, className);
    return (_jsxs(SelectPrimitive.Item, { className: classes, ...props, ref: forwardedRef, children: [_jsx(SelectPrimitive.ItemText, { children: children }), _jsx(SelectPrimitive.ItemIndicator, { className: styles.indicator, children: _jsx(CheckIcon, {}) })] }));
});
