import * as React from "react";
import * as SelectPrimitive from "@radix-ui/react-select";
type Option = string | {
    label?: React.ReactNode;
    value?: string;
    kind?: "title" | "separator" | "item";
    disabled?: boolean;
};
type Props = SelectPrimitive.SelectProps & {
    label?: React.ReactNode;
    icon?: React.FC<React.SVGProps<SVGSVGElement>>;
    options: Option[];
    className?: string;
    placeholder?: string;
    valid?: boolean;
    error?: boolean | string;
    compact?: boolean;
    loading?: boolean;
};
export default function CustomSelect({ label, icon, options, className, valid, error, compact, loading, disabled, value, defaultValue, name, required, placeholder, onValueChange, open, defaultOpen, onOpenChange, }: Props): import("react/jsx-runtime").JSX.Element;
export {};
//# sourceMappingURL=custom-select.d.ts.map