"use client";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import classNames from "classnames";
import * as CollapsiblePrimitive from "@radix-ui/react-collapsible";
import Button from "../button";
import Tooltip from "../tooltip";
import CloseIcon from "../icons/close";
import ExpandUpDownIcon from "../icons/expand-up-down";
import css from "./collapsible.module.css";
export default function Collapsible({ title, visibleContent, hiddenContent, toggleTooltip, open, onOpenChange, className, compact, }) {
    const classes = classNames(css.root, className, {
        [css.compact]: compact,
    });
    return (_jsxs(CollapsiblePrimitive.Root, { className: classes, open: open, onOpenChange: onOpenChange, children: [_jsxs("div", { className: css.header, children: [_jsx("span", { className: css.title, children: title }), _jsx(Tooltip, { content: toggleTooltip, children: _jsx(CollapsiblePrimitive.Trigger, { asChild: true, children: _jsx(Button, { variant: "secondary", className: css.toggle, compact: compact, children: open ? _jsx(CloseIcon, {}) : _jsx(ExpandUpDownIcon, {}) }) }) })] }), visibleContent, _jsx(CollapsiblePrimitive.Content, { children: hiddenContent })] }));
}
