"use client";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import classNames from "classnames";
import * as Ripple from "../ripple";
import css from "./checkbox.module.css";
const Checkbox = React.forwardRef(({ label, className, onChange, onCheckedChange, checked, disabled, required, appearance = "checkbox", ...props }, ref) => {
    const _onChange = (e) => {
        onChange?.(e);
        onCheckedChange?.(e.target.checked);
    };
    const createRipple = (e) => {
        if (disabled)
            return;
        e.stopPropagation();
        Ripple.create(e);
    };
    const classes = classNames(css.field, className, {
        [css.disabled]: disabled,
    });
    const visualInputClasses = classNames({
        [css.checkmark]: appearance === "checkbox",
        [css.switch]: appearance === "switch",
    });
    return (_jsxs("label", { ref: ref, className: classes, children: [_jsx("input", { className: css.checkbox, onChange: _onChange, type: "checkbox", checked: checked, disabled: disabled, required: required, ...props }), _jsx("span", { className: visualInputClasses, onMouseDown: createRipple }), label && _jsx("div", { className: css.label, children: label })] }));
});
export default Checkbox;
