"use client";
import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import classNames from "classnames";
import * as Ripple from "../ripple";
import css from "./button.module.css";
const Button = React.forwardRef(({ tag = "button", variant = "primary", className, compact, children, onMouseDown, onKeyDown, onKeyUp, noRipple, ...props }, ref) => {
    const down = React.useRef(false);
    const mouseDowned = (e) => {
        onMouseDown?.(e);
        if (variant === "link" || props.disabled || noRipple)
            return;
        Ripple.create(e);
    };
    const keyDowned = (e) => {
        e.stopPropagation();
        if (!down.current && (e.code === "Space" || e.code === "Enter")) {
            Ripple.create(e);
        }
        onKeyDown?.(e);
        down.current = true;
    };
    const keyUp = (e) => {
        e.stopPropagation();
        onKeyUp?.(e);
        down.current = false;
    };
    const classes = classNames(css.button, className, css[variant], {
        [css.compact]: compact,
        [css.iconOnly]: typeof children === "object",
    });
    const Tag = tag;
    const defaultType = tag === "button" ? "button" : undefined;
    return (_jsx(Tag, { ref: ref, type: defaultType, ...props, onMouseDown: mouseDowned, onKeyDown: keyDowned, onKeyUp: keyUp, className: classes, children: children }));
});
export default Button;
