export interface Args {
  help: boolean;
  version: boolean;
  dryRun: boolean;
  installCompletions: boolean;
}

export function parseArgs(args: string[]): Args {
  return {
    help: args.includes("-h") || args.includes("--help"),
    version: args.includes("-v") || args.includes("--version"),
    dryRun: args.includes("-d") || args.includes("--dry-run"),
    installCompletions: args.includes("--install-completions"),
  };
}
