#!/usr/bin/env bun

import { publish } from "../src/publish.ts";
import { parseArgs } from "../src/args.ts";
import { installCompletions } from "../src/completions.ts";

const args = parseArgs(process.argv.slice(2));

if (args.help) {
  console.log(`
jpub - Publish packages to nvps.jeantinland.com

Usage:
  jpub [options]

Options:
  -h, --help              Show this help message
  -v, --version           Show version
  -d, --dry-run           Show what would be published without actually publishing
  --install-completions   Install shell completions (bash/zsh/fish)

The command reads package.json from the current directory and:
  1. Creates a .tar.gz archive with files specified in the "files" field
  2. Checks if the version already exists on the remote server
  3. Uploads to nvps.jeantinland.com:packages/{package-name}/@{version}/
`);
  process.exit(0);
}

if (args.version) {
  const pkg = await Bun.file(
    new URL("../package.json", import.meta.url)
  ).json();
  console.log(`jpub v${pkg.version}`);
  process.exit(0);
}

if (args.installCompletions) {
  await installCompletions();
  process.exit(0);
}

try {
  await publish({ dryRun: args.dryRun });
} catch (error) {
  console.error(
    `\x1b[31mError:\x1b[0m ${error instanceof Error ? error.message : error}`
  );
  process.exit(1);
}
