export function format(layouts) {
    return layouts.map((layout) => {
        const isIndex = layout === "/";
        const name = buildName(isIndex ? "/index" : layout);
        return { name, view: layout };
    });
}
function buildName(filename) {
    return filename
        .substring(1)
        .split("-")
        .map((word) => word[0].toUpperCase() + word.substring(1))
        .join(" ");
}
