function queryString(params) {
    return Object.keys(params)
        .map((key) => key.concat("=", params[key]))
        .join("&");
}
export async function getJson(path, retries = 5) {
    try {
        const res = await fetch(path);
        return res.json();
    }
    catch (err) {
        if (retries > 0) {
            const plural = retries > 1 ? "s" : "";
            console.warn(`Warning: failed to fetch json ressource "${path}", retrying ${retries} time${plural}...}`);
            return getJson(path, retries - 1);
        }
        else {
            throw err;
        }
    }
}
export async function getText(host, path, params, retries = 5) {
    const prefix = host.concat("/api", path);
    const url = params ? prefix.concat("?", queryString(params)) : prefix;
    try {
        const res = await fetch(url);
        return res.text();
    }
    catch (err) {
        if (retries > 0) {
            const plural = retries > 1 ? "s" : "";
            console.warn(`Warning: failed to fetch text ressource "${url}", retrying ${retries} time${plural}...}`);
            return getText(host, path, params, retries - 1);
        }
        else {
            throw err;
        }
    }
}
export async function GET(host, path, params) {
    const prefix = host.concat("/api", path);
    const url = params ? prefix.concat("?", queryString(params)) : prefix;
    return getJson(url);
}
export async function POST(host, path, payload, _headers = {}) {
    const url = host.concat("/api", path);
    const method = "POST";
    const headers = { "Content-Type": "application/json", ..._headers };
    const body = JSON.stringify(payload);
    const res = await fetch(url, { method, headers, body });
    return res.json();
}
