import * as API from "./api";
import { getConfig } from "./config";
export default async function revalidate(req, res) {
    try {
        const { edenApi, site } = getConfig();
        const { token: _token, path, lang, all } = req.query;
        if (!_token) {
            return res.status(403).send({ error: "no token provided" });
        }
        const token = typeof _token === "string" ? _token : _token.join("");
        const { message } = await API.checkToken(edenApi, token);
        if (message !== "token-valid") {
            return res.status(403).send({ error: "invalid token" });
        }
        if (all) {
            if (!lang) {
                return res.status(400).send({ error: "no lang provided" });
            }
            const exportPathMap = await API.getExportPathMap(edenApi, site, lang);
            const barePaths = Object.keys(exportPathMap);
            const paths = barePaths.map((key) => {
                return key.concat("/").replace("//", "/").replace(`/${lang}`, "");
            });
            for await (const path of paths) {
                await res.revalidate(path);
            }
            return res.send({ status: "revalidated all" });
        }
        if (!path) {
            return res.status(400).send({ error: "no path provided" });
        }
        const target = typeof path === "string" ? path : "/" + path.join("/");
        await res.revalidate(target);
        return res.send({ status: "revalidated" });
    }
    catch (err) {
        console.error(err);
        return res.status(500).send({ error: "server error" });
    }
}
