import { GET, getText } from "../utils/http";
export async function fetchZone(host, site, lang, path, id, skipReverse = false) {
    return getText(host, "/zone", {
        site,
        lang,
        path,
        id,
        skipReverse: String(skipReverse),
    });
}
export async function fetchZones(host, site, lang, path, skipReverse = false) {
    return GET(host, "/zones", {
        site,
        lang,
        path,
        skipReverse: String(skipReverse),
    });
}
export async function fetchMenus(host, site, lang, from, depth = 1, root = false) {
    return GET(host, "/menus", {
        site,
        lang,
        from,
        depth: String(depth),
        root: String(root),
    });
}
export async function fetchLinks(host, site, lang, menus) {
    if (!menus?.length)
        return [];
    return GET(host, "/links", { site, lang, menus: menus.join(",") });
}
