import * as API from "./api";
export const EDEN_TOKEN = "eden_token";
const tokenRegex = /.*\.(.*)\..*/;
function decodeToken() {
    try {
        if (typeof sessionStorage === "undefined")
            return;
        const token = window.sessionStorage.getItem(EDEN_TOKEN);
        if (!token)
            return;
        const extracted = tokenRegex.exec(token);
        if (extracted === null || extracted.length !== 2)
            return;
        const value = extracted[1];
        const decoded = decodeURIComponent(escape(atob(value)));
        return JSON.parse(decoded);
    }
    catch { }
}
export function isConnected() {
    return decodeToken() !== undefined;
}
export async function setup(config) {
    const edenConfig = await API.getConfig();
    window.EdenConfig = { ...edenConfig, ...config };
}
