export default function buildConfig(edenConfig) {
    const { edenApi, site, langs, domains, siteName, preProd, langPrefix } = edenConfig;
    return {
        trailingSlash: true,
        env: {
            EDEN_API: edenApi,
            SITE: site,
            LANGS: langs.join(","),
            LANG_PREFIX: JSON.stringify(langPrefix),
            DOMAINS: JSON.stringify(domains),
            SITE_NAME: siteName,
            PRE_PROD: JSON.stringify(preProd),
        },
    };
}
export function getConfig() {
    return {
        edenApi: process.env.EDEN_API,
        site: process.env.SITE,
        langs: process.env.LANGS.split(","),
        langPrefix: Boolean(JSON.parse(process.env.LANG_PREFIX)),
        domains: JSON.parse(process.env.DOMAINS),
        siteName: process.env.SITE_NAME,
        preProd: JSON.parse(process.env.PRE_PROD),
    };
}
