import { jsx as _jsx } from "react/jsx-runtime";
import { useEdenContext } from "./context";
import useDateHiddenBlocks from "../hooks/use-date-hidden-blocks";
import usePatchedInternalLinks from "../hooks/use-patched-internal-links";
export default function EdenPage({ layouts }) {
    const { config, pageProps } = useEdenContext();
    const Layout = findLayout(layouts, config.layout);
    useDateHiddenBlocks();
    usePatchedInternalLinks();
    if (!Layout) {
        return null;
    }
    return _jsx(Layout, { ...pageProps });
}
function findLayout(layouts, layout) {
    if (layout in layouts) {
        return layouts[layout];
    }
}
