import { jsx as _jsx } from "react/jsx-runtime";
import NextLink from "next/link";
import * as Path from "../utils/path";
import { useEdenContext } from "./context";
export default function Link({ ref, title, children, ...props }) {
    const { lang, config, isConnected } = useEdenContext();
    const innerHTML = title && !children ? { __html: title } : undefined;
    const href = props.as || props.href;
    const isObject = typeof href === "object";
    const path = isObject ? href.pathname : href;
    const staticPath = Path.toStatic(path);
    const isExternal = staticPath.startsWith("http");
    const localizedPath = isExternal
        ? staticPath
        : Path.toLocalized(path, lang, config.langPrefix);
    const asPath = isObject
        ? { ...href, pathname: localizedPath }
        : localizedPath;
    const target = isExternal ? "_blank" : undefined;
    const rel = isExternal ? "noopener noreferrer" : undefined;
    if (isConnected) {
        return (_jsx("a", { ref: ref, dangerouslySetInnerHTML: innerHTML, target: target, rel: rel, ...props, href: localizedPath, children: children }));
    }
    return (_jsx(NextLink, { ref: ref, dangerouslySetInnerHTML: innerHTML, target: target, rel: rel, ...props, href: asPath, prefetch: undefined, children: children }));
}
