import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { notFound, redirect } from "next/navigation";
import EdenContextProvider from "./context";
import EdenHead from "./head";
import EdenLoader from "./loader";
import * as API from "../services/api";
import * as Breadcrumb from "../services/breadcrumb";
import { fetchLinks } from "../services/fetcher";
import { getConfig } from "../services/config";
import * as Layouts from "../utils/layouts";
const { edenApi, site, langs, domains, langPrefix, siteName, preProd } = getConfig();
export default async function EdenLayout({ layouts, imports, params, className, children, }) {
    let { locale = langs[0], path = [""] } = await params;
    if (langPrefix) {
        locale = path[0];
        path = path.slice(1);
    }
    if (langPrefix && !langs.includes(locale)) {
        return redirect(`/${langs[0]}/`);
    }
    const fullPath = getFullPath(path);
    const localizedPath = await getLocalizedPath(langs, locale, fullPath);
    const [links, page] = await Promise.all([
        fetchLinks(edenApi, site, locale, [localizedPath]),
        API.getPage(edenApi, site, locale, fullPath),
    ]);
    const layout = links?.[0]?.page;
    const hasLayout = Boolean(layout);
    if (!hasLayout) {
        return notFound();
    }
    const { seo, zones, breadcrumb } = page || {};
    const domain = domains[locale];
    const breadcrumbClone = Breadcrumb.deepClone(breadcrumb);
    const menuPath = Breadcrumb.reverse(breadcrumbClone);
    const isInactive = !menuPath?.active;
    if (isInactive) {
        return notFound();
    }
    const langSwitches = await API.getLangSwitches(edenApi, site, locale, langs, menuPath.path);
    const edenContext = {
        layout,
        edenApi,
        site,
        lang: locale,
        path: fullPath,
        menuPath,
        breadcrumb,
        zones,
        seo,
        metadata: menuPath.metadata || {},
        langPrefix,
        domain,
        langSwitches,
    };
    const { getProps } = await imports[layout];
    let pageProps = {};
    if (typeof getProps === "function") {
        pageProps = await getProps(edenContext);
    }
    const config = {
        edenApi,
        site,
        lang: locale,
        langs,
        domains,
        siteName,
        preProd,
        layout: edenContext.layout,
        layouts: Layouts.format(layouts),
        langPrefix,
    };
    return (_jsx(EdenContextProvider, { value: {
            edenMode: null,
            isConnected: false,
            ...edenContext,
            config,
            pageProps,
        }, children: _jsxs("html", { lang: locale, className: className, children: [_jsx(EdenHead, {}), _jsx("body", { children: children }), _jsx(React.Suspense, { fallback: null, children: _jsx(EdenLoader, { config: config }) })] }) }));
}
function getFullPath(path) {
    return "/".concat(path.join("/"));
}
async function getLocalizedPath(edenLocales, locale, fullPath) {
    if (locale === edenLocales[0]) {
        return fullPath;
    }
    return API.getLocalizedPath(edenApi, site, edenLocales, locale, fullPath, edenLocales[0]);
}
export const dynamicParams = true;
export async function generateStaticParams() {
    const exportPathMap = await API.getExportPathMap(edenApi, site, langs.join(","));
    const paths = Object.keys(exportPathMap).map((key) => {
        if (langPrefix) {
            return { path: key.substring(1).split("/") };
        }
        const [locale, ...path] = key.substring(1).split("/");
        return langs.length === 1 ? { path } : { locale, path };
    });
    return paths;
}
