import { jsx as _jsx } from "react/jsx-runtime";
import { describe, it, expect } from "vitest";
import { render } from "@testing-library/react";
import EnterKey from "../icons/enter-key";
import Eye from "../icons/eye";
import EyeOff from "../icons/eye-off";
import Loading from "../icons/loading";
describe("Icon Components", () => {
    describe("EnterKey", () => {
        it("should render SVG element", () => {
            const { container } = render(_jsx(EnterKey, {}));
            const svg = container.querySelector("svg");
            expect(svg).toBeTruthy();
        });
        it("should have correct dimensions", () => {
            const { container } = render(_jsx(EnterKey, {}));
            const svg = container.querySelector("svg");
            expect(svg?.getAttribute("width")).toBe("24");
            expect(svg?.getAttribute("height")).toBe("24");
        });
        it("should have correct viewBox", () => {
            const { container } = render(_jsx(EnterKey, {}));
            const svg = container.querySelector("svg");
            expect(svg?.getAttribute("viewBox")).toBe("0 0 24 24");
        });
        it("should apply custom className", () => {
            const { container } = render(_jsx(EnterKey, { className: "custom-icon" }));
            const svg = container.querySelector("svg");
            expect(svg?.classList.contains("custom-icon")).toBe(true);
        });
        it("should contain path elements", () => {
            const { container } = render(_jsx(EnterKey, {}));
            const paths = container.querySelectorAll("path");
            expect(paths.length).toBe(2);
        });
    });
    describe("Eye", () => {
        it("should render SVG element", () => {
            const { container } = render(_jsx(Eye, {}));
            const svg = container.querySelector("svg");
            expect(svg).toBeTruthy();
        });
        it("should have correct dimensions", () => {
            const { container } = render(_jsx(Eye, {}));
            const svg = container.querySelector("svg");
            expect(svg?.getAttribute("width")).toBe("24");
            expect(svg?.getAttribute("height")).toBe("24");
        });
        it("should have correct viewBox", () => {
            const { container } = render(_jsx(Eye, {}));
            const svg = container.querySelector("svg");
            expect(svg?.getAttribute("viewBox")).toBe("0 0 24 24");
        });
        it("should apply custom className", () => {
            const { container } = render(_jsx(Eye, { className: "eye-icon" }));
            const svg = container.querySelector("svg");
            expect(svg?.classList.contains("eye-icon")).toBe(true);
        });
        it("should contain path elements", () => {
            const { container } = render(_jsx(Eye, {}));
            const paths = container.querySelectorAll("path");
            expect(paths.length).toBe(2);
        });
        it("should render consistently", () => {
            const { container: container1 } = render(_jsx(Eye, {}));
            const { container: container2 } = render(_jsx(Eye, {}));
            const svg1 = container1.querySelector("svg");
            const svg2 = container2.querySelector("svg");
            expect(svg1?.outerHTML).toBe(svg2?.outerHTML);
        });
    });
    describe("EyeOff", () => {
        it("should render SVG element", () => {
            const { container } = render(_jsx(EyeOff, {}));
            const svg = container.querySelector("svg");
            expect(svg).toBeTruthy();
        });
        it("should have correct dimensions", () => {
            const { container } = render(_jsx(EyeOff, {}));
            const svg = container.querySelector("svg");
            expect(svg?.getAttribute("width")).toBe("24");
            expect(svg?.getAttribute("height")).toBe("24");
        });
        it("should have correct viewBox", () => {
            const { container } = render(_jsx(EyeOff, {}));
            const svg = container.querySelector("svg");
            expect(svg?.getAttribute("viewBox")).toBe("0 0 24 24");
        });
        it("should apply custom className", () => {
            const { container } = render(_jsx(EyeOff, { className: "eye-off-icon" }));
            const svg = container.querySelector("svg");
            expect(svg?.classList.contains("eye-off-icon")).toBe(true);
        });
        it("should contain path elements", () => {
            const { container } = render(_jsx(EyeOff, {}));
            const paths = container.querySelectorAll("path");
            expect(paths.length).toBeGreaterThan(0);
        });
        it("should render differently from Eye icon", () => {
            const { container: eyeContainer } = render(_jsx(Eye, {}));
            const { container: eyeOffContainer } = render(_jsx(EyeOff, {}));
            const eyeSvg = eyeContainer.querySelector("svg");
            const eyeOffSvg = eyeOffContainer.querySelector("svg");
            expect(eyeSvg?.outerHTML).not.toBe(eyeOffSvg?.outerHTML);
        });
    });
    describe("Loading", () => {
        it("should render SVG element", () => {
            const { container } = render(_jsx(Loading, {}));
            const svg = container.querySelector("svg");
            expect(svg).toBeTruthy();
        });
        it("should have correct dimensions", () => {
            const { container } = render(_jsx(Loading, {}));
            const svg = container.querySelector("svg");
            expect(svg?.getAttribute("width")).toBe("24");
            expect(svg?.getAttribute("height")).toBe("24");
        });
        it("should have correct viewBox", () => {
            const { container } = render(_jsx(Loading, {}));
            const svg = container.querySelector("svg");
            expect(svg?.getAttribute("viewBox")).toBe("0 0 24 24");
        });
        it("should apply custom className", () => {
            const { container } = render(_jsx(Loading, { className: "loading-icon" }));
            const svg = container.querySelector("svg");
            expect(svg?.classList.contains("loading-icon")).toBe(true);
        });
        it("should contain path element", () => {
            const { container } = render(_jsx(Loading, {}));
            const paths = container.querySelectorAll("path");
            expect(paths.length).toBe(1);
        });
        it("should be suitable for animation", () => {
            const { container } = render(_jsx(Loading, {}));
            const svg = container.querySelector("svg");
            const paths = svg?.querySelectorAll("path");
            expect(paths).toBeTruthy();
            expect(paths.length).toBeGreaterThan(0);
        });
    });
    describe("All Icons", () => {
        it("should all have xmlns attribute", () => {
            const icons = [
                _jsx(EnterKey, {}, "enter"),
                _jsx(Eye, {}, "eye"),
                _jsx(EyeOff, {}, "eyeoff"),
                _jsx(Loading, {}, "loading"),
            ];
            icons.forEach((icon) => {
                const { container } = render(icon);
                const svg = container.querySelector("svg");
                expect(svg?.getAttribute("xmlns")).toBe("http://www.w3.org/2000/svg");
            });
        });
        it("should all have same dimensions", () => {
            const icons = [
                _jsx(EnterKey, {}, "enter"),
                _jsx(Eye, {}, "eye"),
                _jsx(EyeOff, {}, "eyeoff"),
                _jsx(Loading, {}, "loading"),
            ];
            icons.forEach((icon) => {
                const { container } = render(icon);
                const svg = container.querySelector("svg");
                expect(svg?.getAttribute("width")).toBe("24");
                expect(svg?.getAttribute("height")).toBe("24");
                expect(svg?.getAttribute("viewBox")).toBe("0 0 24 24");
            });
        });
        it("should all accept className prop", () => {
            const icons = [
                _jsx(EnterKey, { className: "test" }, "enter"),
                _jsx(Eye, { className: "test" }, "eye"),
                _jsx(EyeOff, { className: "test" }, "eyeoff"),
                _jsx(Loading, { className: "test" }, "loading"),
            ];
            icons.forEach((icon) => {
                const { container } = render(icon);
                const svg = container.querySelector("svg");
                expect(svg?.classList.contains("test")).toBe(true);
            });
        });
        it("should all render without className when not provided", () => {
            const icons = [
                _jsx(EnterKey, {}, "enter"),
                _jsx(Eye, {}, "eye"),
                _jsx(EyeOff, {}, "eyeoff"),
                _jsx(Loading, {}, "loading"),
            ];
            icons.forEach((icon) => {
                const { container } = render(icon);
                const svg = container.querySelector("svg");
                expect(svg?.getAttribute("class")).toBe(null);
            });
        });
    });
});
