var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenZoneUi_add;
import EdenAddSection from "../block/eden-add-block.js";
import template from "./eden-zone-ui.template.js";
import styles from "./eden-zone-ui.styles.js";
import { isContentNotValidForPaste } from "../../services/clipboard.js";
class EdenZoneUi extends HTMLElement {
    constructor(zone, callbacks, templates, maxBlocks) {
        super();
        _EdenZoneUi_add.set(this, async (e) => {
            this.hidePaste = await isContentNotValidForPaste(this.zone);
            if (this.hidePaste && this.templates?.length === 1) {
                this.callbacks.addBlock(this.templates[0]);
            }
            else {
                document.body.prepend(new EdenAddSection(e, {
                    addBlock: this.callbacks.addBlock,
                    paste: this.callbacks.paste,
                }, this.templates, this.hidePaste));
            }
        });
        this.zone = zone;
        this.callbacks = callbacks;
        this.templates = templates;
        this.maxBlocks = maxBlocks;
        this.user = window.Eden.user;
        this.isAdmin = Boolean(this.user.roles?.includes("eden_admin"));
        this.isSuperAdmin = this.user.email === "jean_tinland";
        this.attachShadow({ mode: "open" });
        this.shadowRoot.innerHTML = template();
        const sheet = new CSSStyleSheet();
        sheet.replaceSync(styles);
        this.shadowRoot.adoptedStyleSheets = [sheet];
    }
    async connectedCallback() {
        this.addButton = this.shadowRoot.querySelector(".button");
        this.addButton.addEventListener("click", __classPrivateFieldGet(this, _EdenZoneUi_add, "f"));
    }
    disconnectedCallback() {
        this.addButton.removeEventListener("click", __classPrivateFieldGet(this, _EdenZoneUi_add, "f"));
    }
}
_EdenZoneUi_add = new WeakMap();
export default EdenZoneUi;
if (!customElements.get("eden-zone-ui")) {
    customElements.define("eden-zone-ui", EdenZoneUi);
}
