import css from "../../services/css.js";
import theme from "./eden-theme.js";
const edenStyles = css `
  /* Body styles */
  ${theme}

  html[data-eden-mode] {
    padding-bottom: var(--eden-main-ui-height);
  }

  [data-eden-mode="editing"] body {
    overflow-x: hidden;
    overflow-y: visible;
  }

  body:has(eden-helper) * {
    cursor: help !important;
  }

  /* Prevent user drag while editing */
  [data-eden-mode="editing"] * {
    user-drag: none;
    -webkit-user-drag: none;
  }

  /* Tooltip styles */
  :where([data-eden-mode="editing"] [data-eden-tooltip]) {
    position: relative;
  }

  :where([data-eden-mode="editing"] [data-eden-tooltip])::before {
    content: attr(data-eden-tooltip);
    position: absolute;
    bottom: calc(100% + 2px);
    left: 6px;
    padding: 8px;
    font-size: 12px;
    font-weight: 400;
    line-height: 1em;
    font-family: var(--eden-content-font);
    letter-spacing: normal;
    color: var(--eden-grey-600);
    background-color: var(--eden-grey-000);
    white-space: nowrap;
    border: 1px solid var(--eden-grey-200);
    border-radius: var(--eden-radius-100);
    user-select: none;
    pointer-events: none;
    box-shadow: var(--eden-shadow-100);
  }

  /* Zones */
  [data-eden-mode="editing"] [data-eden-zone]:not([data-eden-read-only]) {
    outline: 1px dashed var(--eden-grey-300);
  }

  :where(
      [data-eden-mode="editing"] [data-eden-zone]:not([data-eden-read-only])
    ) {
    position: relative;
    background-color: #ffffff10;
  }

  /* Editable content */
  [data-eden-mode="editing"] [contentEditable]:focus {
    outline: 2px solid var(--eden-primary-color);
    outline-offset: 3px;
  }

  /* Hidden items overlay */
  section[data-hidden="true"] {
    position: relative;
  }

  section[data-hidden="true"]::after {
    content: "" !important;
    position: absolute !important;
    top: 3px !important;
    left: 3px !important;
    width: calc(100% - 6px) !important;
    height: calc(100% - 6px) !important;
    background-color: rgba(231, 132, 130, 0.15) !important;
    background-image: linear-gradient(
      135deg,
      rgba(0, 0, 0, 0.1) 12.5%,
      transparent 0,
      transparent 50%,
      rgba(0, 0, 0, 0.1) 0,
      rgba(0, 0, 0, 0.1) 62.5%,
      transparent 0,
      transparent
    ) !important;
    background-size: 5.66px 5.66px;
    border-radius: 8px !important;
    pointer-events: none !important;
  }

  /* Date filtered sections */
  [data-eden-mode="connected"] :where(section[data-dates-scheduled]),
  [data-eden-mode="connected"] :where(section[data-dates-active]) {
    position: relative;
  }

  [data-eden-mode="connected"] :where(section[data-dates-scheduled])::before,
  [data-eden-mode="connected"] :where(section[data-dates-active])::before {
    content: "";
    position: absolute;
    top: 18px;
    left: 16px;
    width: 12px;
    height: 12px;
    border-radius: 50%;
    outline: 2px solid var(--eden-grey-600);
    z-index: 100;
  }

  [data-eden-mode="connected"] :where(section[data-dates-scheduled])::before {
    background-color: var(--eden-yellow-300);
  }

  [data-eden-mode="connected"] :where(section[data-dates-active])::before {
    background-color: var(--eden-green-300);
  }

  [data-eden-mode="connected"]
    :where(section[data-dates-scheduled="false"])::before {
    background-color: var(--eden-red-300);
  }

  [data-eden-mode="connected"] :where(section[data-dates-scheduled])::after,
  [data-eden-mode="connected"] :where(section[data-dates-active])::after {
    position: absolute;
    top: 9px;
    left: 8px;
    padding: 5px 12px 5px 26px;
    font-size: 13px;
    font-weight: 700;
    font-family: var(--eden-content-font);
    background-color: var(--eden-grey-600);
    border-radius: var(--eden-radius-100);
    opacity: 0;
    transition: opacity 160ms var(--eden-transition-easing);
    z-index: 99;
    box-shadow: var(--eden-shadow-100);
  }

  [data-eden-mode="connected"] :where(section[data-dates-scheduled])::after {
    content: var(--eden-label-scheduled, "Programmé") " "
      attr(data-dates-scheduled);
  }

  [data-eden-mode="connected"] :where(section[data-dates-active])::after {
    content: var(--eden-label-active, "Actif") " " attr(data-dates-active);
  }

  [data-eden-mode="connected"]
    :where(section[data-dates-scheduled="false"])::after {
    content: var(--eden-label-disabled, "Désactivé");
  }

  [data-eden-mode="connected"]
    :where(section[data-dates-scheduled]):hover::after,
  [data-eden-mode="connected"] :where(section[data-dates-active]):hover::after {
    opacity: 1;
  }

  /* Force high z-index on currently focused section */
  section:has(eden-block-ui) {
    z-index: 100;
  }

  /* Sections move & remove view transitions */
  ::view-transition-old(root),
  ::view-transition-new(root) {
    animation-duration: var(--eden-view-transition-duration);
  }
`;
export default edenStyles;
