import css from "../../services/css.js";
export default function structureTreeStyles(selector) {
    return css `
    ${selector} > eden-structure-tree {
      display: flex;
      flex-direction: column;
      margin-left: 0;
      scroll-behavior: smooth;
      overflow: auto;
      background: linear-gradient(
          var(--eden-grey-000) 30%,
          hsla(0, 0%, 100%, 0)
        ),
        linear-gradient(hsla(0, 0%, 100%, 0), var(--eden-grey-000) 70%) 0 100%,
        radial-gradient(farthest-side at 50% 0, rgba(0, 0, 0, 0.1), transparent),
        radial-gradient(
            farthest-side at 50% 100%,
            rgba(0, 0, 0, 0.1),
            transparent
          )
          0 100%;
      background-repeat: no-repeat;
      background-size: 100% 30px, 100% 30px, 100% 10px, 100% 10px;
      background-attachment: local, local, scroll, scroll;
      background-color: var(--eden-grey-000);
    }

    eden-structure-tree {
      display: flex;
      flex-direction: column;
      box-sizing: border-box;
      transition: opacity 160ms var(--eden-transition-easing),
        transform 160ms var(--eden-transition-easing);
    }

    eden-structure-tree-node {
      position: relative;
      width: max-content;
      min-width: 100%;
      display: flex;
      flex-direction: column;
      color: var(--eden-grey-500);
    }

    .structure-tree__node {
      display: flex;
      flex-direction: column;
      cursor: pointer;
      filter: none;
    }

    .structure-tree__node--has-subs {
      margin-left: 0;
    }

    .structure-tree__node--disabled {
      cursor: not-allowed;
    }

    eden-structure-tree-node[selected]
      > .structure-tree__node
      > .structure-tree__node-leaf-container
      > .structure-tree__node-leaf {
      color: var(--eden-grey-000);
      background-color: var(--eden-primary-color);
    }

    eden-structure-tree-node[dragged]
      > .structure-tree__node
      .structure-tree__node-leaf {
      color: var(--eden-grey-000);
      background-color: var(--eden-grey-500);
    }

    .structure-tree__dragged-ghost {
      position: absolute;
      top: -1000px;
      left: -1000px;
      height: 26px;
    }

    .structure-tree__node-leaf-container {
      width: 100%;
      display: flex;
      align-items: center;
      gap: 2px;
    }

    .structure-tree__node-leaf {
      flex: 1 1 100%;
      position: relative;
      display: flex;
      align-items: center;
      padding: 0 2px;
      box-sizing: border-box;
      font-size: 13px;
      font-family: var(--eden-content-font);
      color: inherit;
      background-color: transparent;
      border: 0;
      cursor: inherit;
      box-shadow: 0 0 0 1px transparent inset;
      transition: color 160ms var(--eden-transition-easing),
        background-color 160ms var(--eden-transition-easing),
        box-shadow 160ms var(--eden-transition-easing);
    }

    .structure-tree__node--disabled
      > .structure-tree__node-leaf-container
      > .structure-tree__node-leaf {
      filter: opacity(50%) grayscale(100%);
    }

    .structure-tree__node-leaf--top,
    .structure-tree__node-leaf--in,
    .structure-tree__node-leaf--bottom {
      background-color: var(--eden-grey-100);
    }

    .structure-tree__node:not(.structure-tree__node--disabled)
      > .structure-tree__node-leaf-container
      > .structure-tree__node-leaf:active {
      box-shadow: 0 0 0 1px var(--eden-grey-300) inset;
    }

    .structure-tree__node-leaf:focus {
      outline: none;
    }

    .structure-tree__node-leaf:focus-visible {
      outline: 2px solid var(--eden-secondary-color);
      outline-offset: 3px;
    }

    .structure-tree__node-leaf-dropzone-before,
    .structure-tree__node-leaf-dropzone-inside,
    .structure-tree__node-leaf-dropzone-after {
      --bar-height: 4px;

      position: absolute;
      left: 0;
      width: 100%;
      opacity: 0;
      pointer-events: none;
      cursor: copy;
      transition: opacity 160ms var(--eden-transition-easing);
    }

    .structure-tree__node-leaf--top .structure-tree__node-leaf-dropzone-before,
    .structure-tree__node-leaf--in .structure-tree__node-leaf-dropzone-inside,
    .structure-tree__node-leaf--bottom
      .structure-tree__node-leaf-dropzone-after {
      opacity: 1;
    }

    .structure-tree__node-leaf-dropzone-before,
    .structure-tree__node-leaf-dropzone-after {
      height: var(--bar-height);
      background-color: var(--eden-primary-color);
      border-radius: var(--eden-radius-200);
    }

    .structure-tree__node-leaf-dropzone-inside {
      inset: var(--bar-height) 0 var(--bar-height) calc(0px - var(--bar-height));
      height: calc(100% - var(--bar-height) * 2);
      background-color: var(--eden-primary-color);
      border-radius: var(--eden-radius-200);
      z-index: 0;
    }

    .structure-tree__node-leaf-dropzone-before {
      top: 0;
    }

    .structure-tree__node-leaf-dropzone-after {
      bottom: 0;
    }

    .structure-tree__node-leaf-dropzone-before::before,
    .structure-tree__node-leaf-dropzone-inside::before,
    .structure-tree__node-leaf-dropzone-after::before {
      position: absolute;
      left: 6px;
      bottom: calc(100% + 4px);
      padding: 4px;
      color: var(--eden-grey-000);
      font-weight: 700;
      font-size: 12px;
      background-color: var(--eden-primary-color);
      border-radius: var(--eden-radius-100);
      box-shadow: var(--eden-shadow-100);
      pointer-events: none;
      z-index: 10;
    }

    .structure-tree__node-leaf-dropzone-before::before {
      content: var(--eden-label-before, "Avant");
    }

    .structure-tree__node-leaf-dropzone-inside::before {
      content: var(--eden-label-inside, "Dedans");
    }

    .structure-tree__node-leaf-dropzone-after::before {
      content: var(--eden-label-after, "Apres");
      top: calc(100% + 4px);
      bottom: unset;
    }

    .structure-tree__node-leaf-dropzone-before::after,
    .structure-tree__node-leaf-dropzone-after::after {
      content: "";
      position: absolute;
      top: calc(50% - 6px);
      right: calc(100% - 12px);
      width: 12px;
      height: 12px;
      background-color: var(--eden-secondary-color);
      border-radius: 50%;
    }

    .structure-tree__node-caret {
      display: none;
      width: 18px;
      height: 32px;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      transition: background-color 160ms var(--eden-transition-easing);
    }

    .structure-tree__node-caret:hover {
      background-color: rgba(0, 0, 0, 0.1);
    }

    .structure-tree__node-caret-inner {
      display: block;
      padding: 2px;
      border: solid var(--eden-grey-500);
      border-width: 0 1px 1px 0;
      transition: transform 160ms var(--eden-transition-easing);
      transform: rotate(-45deg);
    }

    .structure-tree__node-leaf--in .structure-tree__node-caret-inner {
      border: solid var(--eden-grey-000);
      border-width: 0 1px 1px 0;
    }

    .structure-tree__node--has-subs
      > .structure-tree__node-leaf-container
      > .structure-tree__node-leaf
      > .structure-tree__node-caret {
      display: flex;
    }

    eden-structure-tree-node[selected]
      > .structure-tree__node--has-subs
      > .structure-tree__node-leaf-container
      > .structure-tree__node-leaf
      > .structure-tree__node-caret
      > .structure-tree__node-caret-inner,
    eden-structure-tree-node[dragged]
      > .structure-tree__node--has-subs
      > .structure-tree__node-leaf-container
      > .structure-tree__node-leaf
      > .structure-tree__node-caret
      > .structure-tree__node-caret-inner {
      border: solid var(--eden-grey-000);
      border-width: 0 1px 1px 0;
    }

    eden-structure-tree-node[opened]
      > .structure-tree__node
      > .structure-tree__node-leaf-container
      > .structure-tree__node-leaf
      > .structure-tree__node-caret
      > .structure-tree__node-caret-inner {
      transform: rotate(45deg);
    }

    eden-structure-tree-node > .structure-tree__node > eden-structure-tree {
      display: none;
    }

    eden-structure-tree-node[opened]
      > .structure-tree__node
      > eden-structure-tree {
      position: relative;
      display: block;
      animation: structure-tree-node-opening 160ms var(--eden-transition-easing);
    }

    @keyframes structure-tree-node-opening {
      0% {
        opacity: 0;
        transform: translateY(-4px);
      }
    }

    eden-structure-tree-node[closing]
      > .structure-tree__node
      > eden-structure-tree {
      display: block;
      opacity: 0;
      transform: translateY(-4px);
    }

    eden-structure-tree-node
      > .structure-tree__node
      > eden-structure-tree
      > eden-structure-tree-node
      .structure-tree__node-leaf {
      padding-left: calc(18px * var(--structure-tree-node-depth, 1));
    }

    .structure-tree__node-icon-container {
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .structure-tree__node-icon {
      width: 18px;
      height: 18px;
      margin-right: 5px;
      padding: 2px;
      fill: var(--eden-grey-500);
      background-color: white;
      border-radius: 50%;
    }

    .structure-tree__node-label {
      position: relative;
      padding: 6px 2px;
      white-space: nowrap;
      border-radius: var(--eden-radius-100);
      outline: none;
    }

    .structure-tree__node-leaf--in .structure-tree__node-label {
      color: var(--eden-grey-000);
    }

    .structure-tree__node-label[contentEditable]:focus {
      outline: 2px solid var(--eden-primary-color);
      outline-offset: 3px;
    }

    .structure-tree__node-leaf-mounted {
      flex: 0 0 34px;
      height: 34px;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 0;
      background-color: transparent;
      border: 0;
      border-radius: var(--eden-radius-200);
      cursor: pointer;
      transition: background-color 160ms var(--eden-transition-easing);
    }

    .structure-tree__node-leaf-mounted:hover {
      background-color: var(--eden-grey-100);
    }

    .structure-tree__node-leaf-mounted-icon {
      flex: 0 0 16px;
      height: 16px;
      fill: var(--eden-grey-600);
    }

    .structure-tree__inner-right {
      flex: 1 1 70%;
      position: relative;
      background-color: var(--eden-grey-100);
      border-left: 1px solid var(--eden-grey-100);
    }
  `;
}
