import css from "../../services/css.js";
const defaultOptions = {
    color: "var(--eden-grey-600)",
    backgroundColor: "var(--eden-grey-100)",
    border: "1px solid var(--eden-grey-200)",
    fontSize: "inherit",
    parentSelector: "",
    additionalStyles: "",
};
const keyShortcutsStyles = (customOptions = {}) => {
    const options = { ...defaultOptions, ...customOptions };
    const { color, backgroundColor, border, fontSize, parentSelector, additionalStyles, } = options;
    return css `
    ${parentSelector} .shortcut {
      align-self: center;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 2px;
      margin-left: 3px;
      font-size: ${fontSize};
      font-family: var(--eden-content-font);
    }

    ${parentSelector} .key {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 0 3px;
      color: ${color};
      background-color: ${backgroundColor};
      border: ${border};
      border-radius: var(--eden-radius-100);
    }

    ${additionalStyles}
  `;
};
export default keyShortcutsStyles;
