var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenStructureTreeButtons_renderStructureTreeButtons;
import html from "../../services/html.js";
import { generateShortcut } from "../../services/keys.js";
import t from "../../i18n/index.js";
class EdenStructureTreeButtons extends HTMLElement {
    constructor() {
        super();
        _EdenStructureTreeButtons_renderStructureTreeButtons.set(this, () => {
            const removeTooltip = t("structure.remove-page");
            const addTooltip = `${t("structure.add-page")} ${generateShortcut("ctrl", "p")}`;
            const renameTooltip = `${t("structure.rename-page")} ${generateShortcut("ctrl", "e")}`;
            const cancelTooltip = `${t("structure.cancel")} ${generateShortcut(t("common.escape"))}`;
            const confirmTooltip = `${t("structure.save-modifications")} ${generateShortcut("enter")}`;
            this.innerHTML = html `
      <button
        is="eden-button"
        class="structure-tree__button structure-tree__button--remove"
        tooltip="${removeTooltip}"
      >
        <eden-icon
          code="delete"
          class="structure-tree__button-icon"
        ></eden-icon>
      </button>
      <button
        is="eden-button"
        class="structure-tree__button structure-tree__button--add"
        tooltip="${addTooltip}"
      >
        <eden-icon code="plus" class="structure-tree__button-icon"></eden-icon>
      </button>
      <button
        is="eden-button"
        class="structure-tree__button structure-tree__button--rename"
        tooltip="${renameTooltip}"
      >
        <eden-icon code="pen" class="structure-tree__button-icon"></eden-icon>
      </button>
      <button
        is="eden-button"
        class="structure-tree__button structure-tree__button--cancel"
        tooltip="${cancelTooltip}"
        hidden=""
      >
        <eden-icon code="close" class="structure-tree__button-icon"></eden-icon>
      </button>
      <button
        is="eden-button"
        class="structure-tree__button structure-tree__button--confirm"
        tooltip="${confirmTooltip}"
        hidden=""
      >
        <eden-icon code="check" class="structure-tree__button-icon"></eden-icon>
      </button>
    `;
        });
    }
    connectedCallback() {
        __classPrivateFieldGet(this, _EdenStructureTreeButtons_renderStructureTreeButtons, "f").call(this);
    }
}
_EdenStructureTreeButtons_renderStructureTreeButtons = new WeakMap();
export default EdenStructureTreeButtons;
if (!customElements.get("eden-structure-tree-buttons")) {
    customElements.define("eden-structure-tree-buttons", EdenStructureTreeButtons);
}
