var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _EdenEditStructure_instances, _a, _EdenEditStructure_nodeClicked, _EdenEditStructure_nodeDoubleClicked, _EdenEditStructure_draggedNodeChanged, _EdenEditStructure_hoveredNodeChanged, _EdenEditStructure_dropIn, _EdenEditStructure_dropSibling, _EdenEditStructure_dropChanged, _EdenEditStructure_addClicked, _EdenEditStructure_scrollToNode, _EdenEditStructure_enterOrEchapPressed, _EdenEditStructure_cleanupPastedValue, _EdenEditStructure_renameClicked, _EdenEditStructure_removeClicked, _EdenEditStructure_undoRename, _EdenEditStructure_endRenameAction, _EdenEditStructure_cancelClicked, _EdenEditStructure_confirmClicked, _EdenEditStructure_dragEnd, _EdenEditStructure_openTreeToCurrentNode, _EdenEditStructure_selectedCurrentNode, _EdenEditStructure_getPaths, _EdenEditStructure_triggerRevalidation, _EdenEditStructure_handleKeyNavigation;
import EdenModal from "../common/eden-modal.js";
import template from "./eden-edit-structure.template.js";
import styles from "./eden-edit-structure.styles.js";
import { slugify } from "../../services/text.js";
import { fetchStructure, sendRevalidateAllBeacon, } from "../../services/fetcher.js";
import { create, remove, rename, move, getNode, } from "../../services/action.js";
import t from "../../i18n/index.js";
import { checkDuplicateEntry } from "../../services/check.js";
import { snackbar } from "../common/eden-snackbar.js";
import { DUPLICATE_NAME } from "../../services/error.js";
import html from "../../services/html.js";
class EdenEditStructure extends HTMLElement {
    constructor() {
        super();
        _EdenEditStructure_instances.add(this);
        _EdenEditStructure_nodeClicked.set(this, async (e) => {
            const customEvent = e;
            const node = customEvent.detail;
            if (node === this.selectedEntry)
                return;
            __classPrivateFieldGet(this, _EdenEditStructure_undoRename, "f").call(this);
            __classPrivateFieldGet(this, _EdenEditStructure_endRenameAction, "f").call(this);
            const structureEntry = this.querySelector("eden-edit-structure-entry");
            if (structureEntry?.unsavedChanges) {
                const modal = new EdenModal({
                    icon: "warning",
                    title: t("structure.unsaved-changes"),
                    width: 540,
                    content: t("structure.unsaved-changes-warning"),
                    buttons: [
                        {
                            value: t("common.continue"),
                            onClick: () => {
                                structureEntry.unsavedChanges = false;
                                __classPrivateFieldGet(this, _EdenEditStructure_nodeClicked, "f").call(this, e);
                            },
                            cssClass: "cancel",
                        },
                        {
                            value: t("common.save-and-continue"),
                            onClick: async () => {
                                await structureEntry.saveNode();
                                __classPrivateFieldGet(this, _EdenEditStructure_nodeClicked, "f").call(this, e);
                            },
                            autofocus: true,
                            cssClass: "confirm",
                        },
                    ],
                    closeButton: false,
                });
                document.body.appendChild(modal);
                return;
            }
            this.selectedEntry = node;
            this.selectedEntry?.style?.setProperty("cursor", "wait");
            if (this.selectedEntry.nodeId) {
                const content = await getNode(this.selectedEntry.nodeId);
                structureEntry.entryData = content;
                structureEntry.setAttribute("entryselected", this.selectedEntry.nodeId.toString());
            }
            this.selectedEntry.setAttribute("selected", "");
            this.setAttribute("entryselected", "");
            Array.from(this.querySelectorAll("eden-structure-tree-node")).forEach((el) => {
                if (el !== this.selectedEntry && el.hasAttribute("selected"))
                    el.removeAttribute("selected");
            });
            this.selectedEntry.style.removeProperty("cursor");
        });
        _EdenEditStructure_nodeDoubleClicked.set(this, () => {
            __classPrivateFieldGet(this, _EdenEditStructure_renameClicked, "f").call(this);
        });
        _EdenEditStructure_draggedNodeChanged.set(this, (e) => {
            const customEvent = e;
            const node = customEvent.detail;
            this.draggedNode = node;
        });
        _EdenEditStructure_hoveredNodeChanged.set(this, (e) => {
            const customEvent = e;
            const node = customEvent.detail;
            this.hoveredRect = node.getBoundingClientRect();
            if (this.hoveredNode) {
                const leaf = this.hoveredNode.querySelector(".structure-tree__node-leaf");
                resetLeafClasses(leaf);
            }
            this.hoveredNode = node;
        });
        _EdenEditStructure_dropIn.set(this, async () => {
            const navTree = this.hoveredNode.querySelector("eden-structure-tree");
            if (navTree && this.hoveredNode.nodeId && this.draggedNode.nodeId) {
                await move(this.hoveredNode.nodeId, this.draggedNode.nodeId, navTree.children.length);
                navTree.insertAdjacentElement("afterend", this.draggedNode);
            }
            else {
                if (this.hoveredNode.nodeId && this.draggedNode.nodeId) {
                    await move(this.hoveredNode.nodeId, this.draggedNode.nodeId, 0);
                }
                const { default: EdenStructureTree } = await import("./eden-structure-tree.js");
                const newNavTree = new EdenStructureTree();
                const node = this.hoveredNode.querySelector(".structure-tree__node");
                if (!node)
                    return;
                node.classList.add("structure-tree__node--has-subs");
                newNavTree.insertAdjacentElement("afterbegin", this.draggedNode);
                node.appendChild(newNavTree);
            }
        });
        _EdenEditStructure_dropSibling.set(this, async (posStep) => {
            const parentNode = getClosestParentNode(this.hoveredNode);
            if (!parentNode)
                return;
            const parentTree = parentNode.querySelector("eden-structure-tree");
            const siblingNode = Array.from(parentTree.children);
            const position = siblingNode.indexOf(this.hoveredNode);
            if (parentNode.nodeId && this.draggedNode.nodeId) {
                await move(parentNode.nodeId, this.draggedNode.nodeId, position + posStep);
            }
            if (posStep === 0) {
                this.hoveredNode.insertAdjacentElement("beforebegin", this.draggedNode);
            }
            else {
                this.hoveredNode.insertAdjacentElement("afterend", this.draggedNode);
            }
        });
        _EdenEditStructure_dropChanged.set(this, async (e) => {
            const customEvent = e;
            const { position } = customEvent.detail;
            const draggedParent = this.draggedNode.closest("eden-structure-tree");
            if (position === "TOP") {
                await __classPrivateFieldGet(this, _EdenEditStructure_dropSibling, "f").call(this, 0);
            }
            if (position === "BOT") {
                await __classPrivateFieldGet(this, _EdenEditStructure_dropSibling, "f").call(this, 1);
            }
            if (position === "IN") {
                await __classPrivateFieldGet(this, _EdenEditStructure_dropIn, "f").call(this);
            }
            if (draggedParent?.querySelectorAll("eden-structure-tree-node").length === 0) {
                draggedParent.parentElement?.classList.remove("structure-tree__node--has-subs");
                draggedParent.remove();
            }
        });
        _EdenEditStructure_addClicked.set(this, async () => {
            if (!this.selectedEntry)
                return;
            const { nodeId } = this.selectedEntry;
            const depth = Number(this.selectedEntry.style.getPropertyValue("--structure-tree-node-depth")) + 1;
            const currentNode = this.querySelector("eden-edit-structure-entry");
            const [rand] = crypto.randomUUID().split("-");
            const name = `new-node-${rand}`;
            if (!nodeId)
                return;
            const result = await checkDuplicateEntry(this.innerLeft, name, nodeId);
            if (result) {
                snackbar(DUPLICATE_NAME(result), "error");
                return;
            }
            const treeChild = this.selectedEntry.querySelector("eden-structure-tree");
            const position = treeChild ? treeChild.children.length : 0;
            const newNodePath = buildNewPath(name, currentNode.entryData.fr.path, currentNode.entryData.virtualPage);
            const newNode = emptyNode(this.createdId--, newNodePath);
            const { id: newId } = await create(newNode, name, position, nodeId);
            const { default: EdenStructureTree } = await import("./eden-structure-tree.js");
            const { default: EdenStructureTreeNode } = await import("./eden-structure-tree-node.js");
            const newNavTreeNode = new EdenStructureTreeNode({
                node: { name, id: newId },
                depth,
            });
            if (treeChild) {
                treeChild.appendChild(newNavTreeNode);
                this.selectedEntry.setAttribute("opened", "");
            }
            else {
                const nodeBlock = this.selectedEntry.querySelector(".structure-tree__node");
                if (!nodeBlock)
                    return;
                nodeBlock.appendChild(new EdenStructureTree({ tree: [] }));
                nodeBlock.classList.add("structure-tree__node--has-subs");
                this.selectedEntry.setAttribute("opened", "");
            }
            const newTree = this.selectedEntry.querySelector("eden-structure-tree");
            newTree.appendChild(newNavTreeNode);
            await __classPrivateFieldGet(this, _EdenEditStructure_nodeClicked, "f").call(this, new CustomEvent("eden-structure-node-clicked", { detail: newNavTreeNode }));
            __classPrivateFieldGet(this, _EdenEditStructure_renameClicked, "f").call(this);
            __classPrivateFieldGet(this, _EdenEditStructure_scrollToNode, "f").call(this, newNavTreeNode);
        });
        _EdenEditStructure_scrollToNode.set(this, (node) => {
            if (!node)
                return;
            const scrollView = this.querySelector("eden-structure-tree");
            const { scrollTop } = scrollView;
            const { top } = node.getBoundingClientRect();
            const { top: parentTop, height } = scrollView.getBoundingClientRect();
            scrollView.scrollTo(0, scrollTop + top - parentTop - height / 2);
        });
        _EdenEditStructure_enterOrEchapPressed.set(this, (e) => {
            if (e.key === "Enter") {
                e.preventDefault();
                __classPrivateFieldGet(this, _EdenEditStructure_confirmClicked, "f").call(this);
            }
            if (e.key === "Escape") {
                e.preventDefault();
                e.stopPropagation();
                __classPrivateFieldGet(this, _EdenEditStructure_cancelClicked, "f").call(this);
            }
        });
        _EdenEditStructure_renameClicked.set(this, () => {
            if (!this.selectedEntry)
                return;
            const oldLeaf = this.selectedEntry.querySelector(".structure-tree__node-label");
            if (!oldLeaf)
                return;
            this.oldLeafLabel = oldLeaf.innerText;
            const selectedLeaf = this.selectedEntry.querySelector(".structure-tree__node-label");
            selectedLeaf.setAttribute("contentEditable", "");
            selectedLeaf.focus();
            document.execCommand("selectAll", false);
            selectedLeaf.addEventListener("paste", __classPrivateFieldGet(this, _EdenEditStructure_instances, "m", _EdenEditStructure_cleanupPastedValue));
            this.removeBtn.setAttribute("disabled", "");
            this.addBtn.setAttribute("disabled", "");
            this.renameBtn.setAttribute("hidden", "");
            this.confirmBtn.removeAttribute("hidden");
            this.cancelBtn.removeAttribute("hidden");
            this.addEventListener("keydown", __classPrivateFieldGet(this, _EdenEditStructure_enterOrEchapPressed, "f"));
        });
        _EdenEditStructure_removeClicked.set(this, async () => {
            const nodeDeletion = async () => {
                if (!this.selectedEntry || !this.selectedEntry.nodeId)
                    return;
                const paths = __classPrivateFieldGet(this, _EdenEditStructure_getPaths, "f").call(this);
                await remove(this.selectedEntry.nodeId, paths);
                const parentTree = this.selectedEntry.parentElement;
                if (!parentTree)
                    return;
                const parentNode = parentTree.parentElement;
                this.selectedEntry.remove();
                this.selectedEntry = undefined;
                this.removeAttribute("entryselected");
                if (parentTree.children.length === 0 && parentNode) {
                    parentTree.remove();
                    parentNode.classList.remove("structure-tree__node--has-subs");
                }
                const firstNode = this.querySelector("eden-structure-tree-node");
                if (firstNode) {
                    firstNode.click();
                }
                __classPrivateFieldGet(this, _EdenEditStructure_endRenameAction, "f").call(this);
            };
            if (!this.selectedEntry)
                return;
            const modal = new EdenModal({
                icon: "delete",
                title: t("structure.remove-entry"),
                content: `${t("structure.remove-confirm")} "${this.selectedEntry.name}" ?`,
                buttons: [
                    { value: t("common.cancel"), cssClass: "cancel" },
                    {
                        value: t("common.remove"),
                        onClick: nodeDeletion,
                        cssClass: "confirm",
                        autofocus: true,
                    },
                ],
                closeButton: false,
            });
            document.body.appendChild(modal);
        });
        _EdenEditStructure_undoRename.set(this, () => {
            if (this.selectedEntry && this.oldLeafLabel) {
                const label = this.selectedEntry.querySelector(".structure-tree__node-label");
                label.innerHTML = this.oldLeafLabel;
            }
            if (this.removeBtn.hasAttribute("disabled"))
                this.removeBtn.removeAttribute("disabled");
            if (this.addBtn.hasAttribute("disabled"))
                this.addBtn.removeAttribute("disabled");
        });
        _EdenEditStructure_endRenameAction.set(this, () => {
            if (!this.selectedEntry)
                return;
            const selectedLeaf = this.selectedEntry.querySelector(".structure-tree__node-label");
            this.oldLeafLabel = undefined;
            if (selectedLeaf) {
                selectedLeaf.removeAttribute("contentEditable");
                selectedLeaf.removeEventListener("paste", __classPrivateFieldGet(this, _EdenEditStructure_instances, "m", _EdenEditStructure_cleanupPastedValue));
            }
            this.confirmBtn.setAttribute("hidden", "");
            this.cancelBtn.setAttribute("hidden", "");
            this.renameBtn.removeAttribute("hidden");
            this.removeBtn.removeAttribute("disabled");
            this.addBtn.removeAttribute("disabled");
            this.removeEventListener("keydown", __classPrivateFieldGet(this, _EdenEditStructure_enterOrEchapPressed, "f"));
        });
        _EdenEditStructure_cancelClicked.set(this, () => {
            __classPrivateFieldGet(this, _EdenEditStructure_undoRename, "f").call(this);
            __classPrivateFieldGet(this, _EdenEditStructure_endRenameAction, "f").call(this);
        });
        _EdenEditStructure_confirmClicked.set(this, async () => {
            if (!this.selectedEntry)
                return;
            const node = this.selectedEntry.querySelector(".structure-tree__node-label");
            const name = slugify(node.innerText);
            if (name === this.oldLeafLabel) {
                __classPrivateFieldGet(this, _EdenEditStructure_endRenameAction, "f").call(this);
                return;
            }
            if (!this.selectedEntry.nodeId)
                return;
            const result = await rename(this.selectedEntry.nodeId, name);
            if (!result.error) {
                node.innerText = name;
                this.selectedEntry.name = name;
            }
            else {
                node.innerText = this.oldLeafLabel || "";
                this.selectedEntry.name = this.oldLeafLabel;
            }
            __classPrivateFieldGet(this, _EdenEditStructure_endRenameAction, "f").call(this);
        });
        _EdenEditStructure_dragEnd.set(this, () => {
            const leafs = Array.from(this.querySelectorAll(".structure-tree__node-leaf"));
            leafs.forEach((leaf) => {
                resetLeafClasses(leaf);
            });
        });
        _EdenEditStructure_openTreeToCurrentNode.set(this, (node) => {
            if (!node || node instanceof _a)
                return;
            if (node.nodeName === "EDEN-STRUCTURE-TREE-NODE") {
                node.setAttribute("opened", "");
                node.opened = true;
            }
            return __classPrivateFieldGet(this, _EdenEditStructure_openTreeToCurrentNode, "f").call(this, node.parentElement);
        });
        _EdenEditStructure_selectedCurrentNode.set(this, (currentNode) => {
            const nodes = Array.from(this.querySelectorAll("eden-structure-tree-node"));
            const selectedNode = nodes.find((node) => node.nodeId === currentNode);
            __classPrivateFieldGet(this, _EdenEditStructure_nodeClicked, "f").call(this, new CustomEvent("eden-structure-node-clicked", { detail: selectedNode }));
            if (!selectedNode)
                return;
            __classPrivateFieldGet(this, _EdenEditStructure_openTreeToCurrentNode, "f").call(this, selectedNode);
            __classPrivateFieldGet(this, _EdenEditStructure_scrollToNode, "f").call(this, selectedNode);
            const button = selectedNode?.querySelector("button");
            if (button) {
                button.focus();
            }
        });
        _EdenEditStructure_getPaths.set(this, () => {
            const langs = window.EdenConfig.langs || [];
            const navEntry = this.querySelector("eden-edit-structure-entry");
            if (!navEntry)
                return [];
            const { entryData } = navEntry;
            const hasVirtualPage = Boolean(entryData.virtualPage);
            const paths = langs.reduce((acc, lang) => {
                if (entryData[lang]?.path && hasVirtualPage) {
                    const path = entryData[lang].path === "/" ? "/" : `${entryData[lang]?.path}/`;
                    return [...acc, { lang, path }];
                }
                else {
                    return acc;
                }
            }, []);
            return paths;
        });
        _EdenEditStructure_triggerRevalidation.set(this, () => {
            if (window.sessionStorage.getItem("eden_revalidation_needed")) {
                sendRevalidateAllBeacon();
            }
        });
        _EdenEditStructure_handleKeyNavigation.set(this, async (e) => {
            const activeElement = document.activeElement?.shadowRoot?.activeElement?.closest("eden-structure-tree-node");
            if ((e.ctrlKey || e.metaKey) && e.key === "p") {
                e.preventDefault();
                e.stopPropagation();
                await __classPrivateFieldGet(this, _EdenEditStructure_addClicked, "f").call(this);
            }
            if ((e.ctrlKey || e.metaKey) && e.key === "e") {
                e.preventDefault();
                e.stopPropagation();
                __classPrivateFieldGet(this, _EdenEditStructure_renameClicked, "f").call(this);
            }
            if (activeElement) {
                const selectedLeaf = activeElement.querySelector(".structure-tree__node-label");
                const isEditing = selectedLeaf?.hasAttribute("contentEditable");
                if (isEditing)
                    return;
                if (e.key === "ArrowRight") {
                    e.preventDefault();
                    activeElement.openNode();
                }
                if (e.key === "ArrowLeft") {
                    e.preventDefault();
                    activeElement.closeNode();
                }
            }
        });
        this.selectedEntry = undefined;
        this.createdId = -1;
        this.innerHTML = html `
      <style>
        ${styles}
      </style>
      ${template()}
    `;
    }
    async connectedCallback() {
        const { lang, langPrefix, layouts } = window.EdenConfig;
        const path = document.location.pathname;
        const { currentNode, structure } = await fetchStructure(path, lang, langPrefix);
        this.templates = layouts;
        this.innerLeft = this.querySelector(".structure-tree__inner-left");
        this.innerRight = this.querySelector(".structure-tree__inner-right");
        const { default: EdenEditStructureEntry } = await import("./eden-edit-structure-entry.js");
        this.innerRight.appendChild(new EdenEditStructureEntry(this.templates));
        const { default: EdenStructureSearch } = await import("./eden-structure-search.js");
        const { default: EdenStructureTree } = await import("./eden-structure-tree.js");
        const { default: EdenStructureTreeButtons } = await import("./eden-structure-tree-buttons.js");
        this.innerLeft.appendChild(new EdenStructureSearch({ editStructure: this, structure }));
        this.innerLeft.appendChild(new EdenStructureTree({ tree: structure, depth: 0 }));
        this.innerLeft.appendChild(new EdenStructureTreeButtons());
        this.addBtn = this.querySelector(".structure-tree__button--add");
        this.removeBtn = this.querySelector(".structure-tree__button--remove");
        this.renameBtn = this.querySelector(".structure-tree__button--rename");
        this.confirmBtn = this.querySelector(".structure-tree__button--confirm");
        this.cancelBtn = this.querySelector(".structure-tree__button--cancel");
        __classPrivateFieldGet(this, _EdenEditStructure_selectedCurrentNode, "f").call(this, currentNode);
        this.addBtn.addEventListener("click", __classPrivateFieldGet(this, _EdenEditStructure_addClicked, "f"));
        this.renameBtn.addEventListener("click", __classPrivateFieldGet(this, _EdenEditStructure_renameClicked, "f"));
        this.removeBtn.addEventListener("click", __classPrivateFieldGet(this, _EdenEditStructure_removeClicked, "f"));
        this.confirmBtn.addEventListener("click", __classPrivateFieldGet(this, _EdenEditStructure_confirmClicked, "f"));
        this.cancelBtn.addEventListener("click", __classPrivateFieldGet(this, _EdenEditStructure_cancelClicked, "f"));
        this.addEventListener("eden-structure-drop-changed", __classPrivateFieldGet(this, _EdenEditStructure_dropChanged, "f"));
        this.addEventListener("eden-structure-dragged-node-changed", __classPrivateFieldGet(this, _EdenEditStructure_draggedNodeChanged, "f"));
        this.addEventListener("eden-structure-overred-node-changed", __classPrivateFieldGet(this, _EdenEditStructure_hoveredNodeChanged, "f"));
        this.addEventListener("eden-structure-node-clicked", __classPrivateFieldGet(this, _EdenEditStructure_nodeClicked, "f"));
        this.addEventListener("eden-structure-node-double-clicked", __classPrivateFieldGet(this, _EdenEditStructure_nodeDoubleClicked, "f"));
        this.addEventListener("eden-structure-drag-end", __classPrivateFieldGet(this, _EdenEditStructure_dragEnd, "f"));
        this.addEventListener("keydown", __classPrivateFieldGet(this, _EdenEditStructure_handleKeyNavigation, "f"));
        window.addEventListener("beforeunload", __classPrivateFieldGet(this, _EdenEditStructure_triggerRevalidation, "f"));
    }
    disconnectedCallback() {
        window.removeEventListener("beforeunload", __classPrivateFieldGet(this, _EdenEditStructure_triggerRevalidation, "f"));
        this.removeEventListener("keydown", __classPrivateFieldGet(this, _EdenEditStructure_handleKeyNavigation, "f"));
        this.removeEventListener("eden-structure-drag-end", __classPrivateFieldGet(this, _EdenEditStructure_dragEnd, "f"));
        this.removeEventListener("eden-structure-node-double-clicked", __classPrivateFieldGet(this, _EdenEditStructure_nodeDoubleClicked, "f"));
        this.removeEventListener("eden-structure-node-clicked", __classPrivateFieldGet(this, _EdenEditStructure_nodeClicked, "f"));
        this.removeEventListener("eden-structure-overred-node-changed", __classPrivateFieldGet(this, _EdenEditStructure_hoveredNodeChanged, "f"));
        this.removeEventListener("eden-structure-dragged-node-changed", __classPrivateFieldGet(this, _EdenEditStructure_draggedNodeChanged, "f"));
        this.removeEventListener("eden-structure-drop-changed", __classPrivateFieldGet(this, _EdenEditStructure_dropChanged, "f"));
        this.removeBtn.removeEventListener("click", __classPrivateFieldGet(this, _EdenEditStructure_removeClicked, "f"));
        this.renameBtn.removeEventListener("click", __classPrivateFieldGet(this, _EdenEditStructure_renameClicked, "f"));
        this.addBtn.removeEventListener("click", __classPrivateFieldGet(this, _EdenEditStructure_addClicked, "f"));
    }
    static get observedAttributes() {
        return ["entryselected"];
    }
    attributeChangedCallback(name, _, newValue) {
        if (name === "entryselected") {
            if (newValue === "") {
                this.addBtn.removeAttribute("disabled");
                this.removeBtn.removeAttribute("disabled");
                this.renameBtn.removeAttribute("disabled");
            }
            else {
                this.addBtn.setAttribute("disabled", "");
                this.removeBtn.setAttribute("disabled", "");
                this.renameBtn.setAttribute("disabled", "");
            }
        }
    }
}
_a = EdenEditStructure, _EdenEditStructure_nodeClicked = new WeakMap(), _EdenEditStructure_nodeDoubleClicked = new WeakMap(), _EdenEditStructure_draggedNodeChanged = new WeakMap(), _EdenEditStructure_hoveredNodeChanged = new WeakMap(), _EdenEditStructure_dropIn = new WeakMap(), _EdenEditStructure_dropSibling = new WeakMap(), _EdenEditStructure_dropChanged = new WeakMap(), _EdenEditStructure_addClicked = new WeakMap(), _EdenEditStructure_scrollToNode = new WeakMap(), _EdenEditStructure_enterOrEchapPressed = new WeakMap(), _EdenEditStructure_renameClicked = new WeakMap(), _EdenEditStructure_removeClicked = new WeakMap(), _EdenEditStructure_undoRename = new WeakMap(), _EdenEditStructure_endRenameAction = new WeakMap(), _EdenEditStructure_cancelClicked = new WeakMap(), _EdenEditStructure_confirmClicked = new WeakMap(), _EdenEditStructure_dragEnd = new WeakMap(), _EdenEditStructure_openTreeToCurrentNode = new WeakMap(), _EdenEditStructure_selectedCurrentNode = new WeakMap(), _EdenEditStructure_getPaths = new WeakMap(), _EdenEditStructure_triggerRevalidation = new WeakMap(), _EdenEditStructure_handleKeyNavigation = new WeakMap(), _EdenEditStructure_instances = new WeakSet(), _EdenEditStructure_cleanupPastedValue = function _EdenEditStructure_cleanupPastedValue(e) {
    e.stopPropagation();
    e.preventDefault();
    const clipboardData = e.clipboardData || window.clipboardData;
    const pastedData = clipboardData.getData("Text");
    const target = e.target;
    if (!target)
        return;
    target.innerText = pastedData;
};
export default EdenEditStructure;
if (!customElements.get("eden-edit-structure")) {
    customElements.define("eden-edit-structure", EdenEditStructure);
}
function emptyNode(id, path) {
    return {
        id,
        active: true,
        highlight: false,
        virtualPage: "",
        metadata: {},
        fr: {
            label: "",
            shortLabel: "",
            path,
            disabled: false,
            seo: {
                title: "",
                keywords: "",
                description: "",
                inSitemap: false,
                frequency: "",
                priority: 0,
                robots: "index, follow",
                canonical: "",
            },
        },
    };
}
function buildNewPath(newNodeName, parentPath, virtualPage) {
    if (!virtualPage) {
        return `/${newNodeName}`;
    }
    const prefix = parentPath && parentPath.endsWith("/") ? parentPath : `${parentPath}/`;
    return `${prefix}${newNodeName}`;
}
function resetLeafClasses(leaf) {
    leaf.classList.remove("structure-tree__node-leaf--top", "structure-tree__node-leaf--in", "structure-tree__node-leaf--bottom");
}
function getClosestParentNode(node) {
    return node.parentElement?.closest("eden-structure-tree-node");
}
